/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.osee.framework.jdk.core.util.IndentedString;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;

public class Message {
    private static final String lineEnding = "\n";
    private static final int lineEndingSize = "\n".length();
    private String cachedResult = null;
    private int indent = 0;
    private final List<Line> lines = new LinkedList<Line>();
    private int mark;

    private static CharSequence copy(CharSequence otherText) {
        if (Objects.isNull(otherText)) {
            return "";
        }
        if (otherText instanceof String) {
            return otherText;
        }
        return new StringBuilder(Message.newSize(otherText.length())).append(otherText);
    }

    private static int newSize(int textSize) {
        int newSize = textSize * 2;
        newSize = newSize < 256 ? 256 : newSize;
        return newSize;
    }

    private static String objectToString(Object object) {
        return Objects.nonNull(object) ? object.toString() : "(null)";
    }

    public Message append(CharSequence text) {
        this.cachedResult = null;
        int size = this.lines.size();
        if (size <= 0) {
            return this;
        }
        Line lastLine = this.lines.get(size - 1);
        if (LineType.TITLE.equals((Object)lastLine.getLineType())) {
            lastLine.appendTitle(text);
        }
        return this;
    }

    public Message blank() {
        this.cachedResult = null;
        this.lines.add(new Line());
        return this;
    }

    public Message block(CharSequence block) {
        this.cachedResult = null;
        this.lines.add(new Line(block));
        return this;
    }

    public Message copy(Message otherMessage) {
        this.cachedResult = null;
        otherMessage.lines.forEach(otherLine -> {
            boolean bl = this.lines.add(new Line(this.indent, (Line)otherLine));
        });
        return this;
    }

    public Message follows(CharSequence title, CharSequence block) {
        Objects.requireNonNull(title, "Message::follows, parameter \"title\" cannot be null.");
        Objects.requireNonNull(block, "Message::follows, parameter \"block\" cannot be null.");
        return this.title(title).indentInc().block(block).indentDec();
    }

    public Message followsIfNonNull(CharSequence title, CharSequence block) {
        return Objects.nonNull(block) ? this.follows(title, block) : this;
    }

    public Message followsIfPresent(CharSequence title, Optional<CharSequence> blockOptional) {
        return Objects.nonNull(blockOptional) && blockOptional.isPresent() ? this.follows(title, blockOptional.get()) : this;
    }

    public Message indent(int indent) {
        this.indent = indent >= 0 ? indent : (indent == -1 ? this.indent : 0);
        return this;
    }

    public Message indentDec() {
        this.indent = this.indent > 0 ? this.indent - 1 : 0;
        return this;
    }

    public Message indentInc() {
        ++this.indent;
        return this;
    }

    public boolean isEmpty() {
        return this.lines.size() == 0;
    }

    public boolean isModified() {
        return this.mark != this.lines.size();
    }

    public void mark() {
        this.mark = this.lines.size();
    }

    public Message reasonFollows(String title, Throwable throwable) {
        Objects.requireNonNull(throwable, "Message::reasonFollows, parameter \"throwable\" cannot be null.");
        String exceptionClass = throwable.getClass().getName();
        String block = throwable.getMessage();
        if (Objects.isNull(block)) {
            block = "(null message)";
        }
        this.title(title);
        this.indentInc();
        this.title(exceptionClass);
        this.title(block);
        this.indentDec();
        return this;
    }

    public Message reasonFollows(Throwable throwable) {
        return this.reasonFollows("Reason Follows", throwable);
    }

    public Message reasonFollowsIfNonNull(Throwable throwable) {
        return Objects.nonNull(throwable) ? this.reasonFollows(throwable) : this;
    }

    public Message reasonFollowsIfPresent(Optional<? extends Throwable> throwableOptional) {
        return Objects.nonNull(throwableOptional) && throwableOptional.isPresent() ? this.reasonFollows(throwableOptional.get()) : this;
    }

    public Message reasonFollowsWithTrace(String title, Throwable throwable) {
        Objects.requireNonNull(throwable, "Message::reasonFollows, parameter \"throwable\" cannot be null.");
        String exceptionClass = throwable.getClass().getName();
        String block = throwable.getMessage();
        if (Objects.isNull(block)) {
            block = "(null message)";
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        String trace = stringWriter.toString();
        if (Objects.isNull(trace)) {
            trace = "(null trace)";
        }
        this.title(title);
        this.indentInc();
        this.title(exceptionClass);
        this.title(block);
        this.title(trace);
        this.indentDec();
        return this;
    }

    public Message reasonFollowsWithTrace(Throwable throwable) {
        return this.reasonFollowsWithTrace("Reason Follows", throwable);
    }

    public <T> Message segment(CharSequence title, T value) {
        return this.segment(title, value, Function.identity());
    }

    public <T> Message segment(CharSequence title, T value, Function<T, ?> valueExtractor) {
        this.cachedResult = null;
        String valueString = Objects.isNull(value) ? "(null)" : Message.objectToString(valueExtractor.apply(value));
        this.lines.add(new Line(this.indent, title, valueString));
        return this;
    }

    public Message segment(Consumer<Message> appender) {
        appender.accept(this);
        return this;
    }

    public <T> Message segmentIfNot(CharSequence title, T value, T notValue) {
        return Objects.nonNull(value) ^ Objects.nonNull(notValue) || Objects.nonNull(value) && !value.equals(notValue) ? this.segment(title, value) : this;
    }

    public <T> Message segmentIfNotNull(CharSequence title, Object value) {
        return Objects.nonNull(value) ? this.segment(title, value) : this;
    }

    public <T> Message segmentIfNotNull(CharSequence title, Supplier<T> valueSupplier, Object testValue) {
        return Objects.nonNull(testValue) && Objects.nonNull(valueSupplier) ? this.segment(title, valueSupplier.get()) : this;
    }

    public <T> Message segmentIndexed(CharSequence title, Collection<T> valueCollection) {
        return this.segmentIndexed(title, valueCollection, t -> t, -1);
    }

    public <T> Message segmentIndexed(CharSequence title, Collection<T> valueCollection, Function<T, ?> valueExtractor) {
        return this.segmentIndexed(title, valueCollection, valueExtractor, -1);
    }

    public <T> Message segmentIndexed(CharSequence title, Collection<T> valueCollection, Function<T, ?> valueExtractor, int limit) {
        this.cachedResult = null;
        if (Objects.isNull(valueCollection)) {
            this.lines.add(new Line(this.indent, title, "(null)"));
            return this;
        }
        if (valueCollection.isEmpty()) {
            this.lines.add(new Line(this.indent, title, "(empty)"));
            return this;
        }
        this.lines.add(new Line(this.indent++, title));
        int safety = 0;
        StringBuilder listElementTitle = new StringBuilder();
        int count = 0;
        for (T entry : valueCollection) {
            Object displayValue = valueExtractor.apply(entry);
            listElementTitle.setLength(0);
            listElementTitle.append("[").append(count++).append("]");
            if (displayValue instanceof ToMessage) {
                this.lines.add(new Line(this.indent, listElementTitle));
                ((ToMessage)displayValue).toMessage(this.indent + 1, this);
                --this.indent;
            } else {
                this.lines.add(new Line(this.indent, listElementTitle.toString(), Message.objectToString(displayValue)));
            }
            if (limit > 0 && ++safety >= limit) break;
        }
        --this.indent;
        return this;
    }

    public <T> Message segmentIndexed(CharSequence title, T[] valueArray) {
        return this.segmentIndexed(title, valueArray, (T t) -> t);
    }

    public <T> Message segmentIndexed(CharSequence title, T[] valueArray, Function<T, ?> valueExtractor) {
        this.cachedResult = null;
        if (Objects.isNull(valueArray)) {
            this.lines.add(new Line(this.indent, title, "(null)"));
            return this;
        }
        if (valueArray.length <= 0) {
            this.lines.add(new Line(this.indent, title, "(empty)"));
            return this;
        }
        this.lines.add(new Line(this.indent++, title));
        int i = 0;
        StringBuilder listElementTitle = new StringBuilder();
        T[] TArray = valueArray;
        int n = valueArray.length;
        int n2 = 0;
        while (n2 < n) {
            T value = TArray[n2];
            Object displayValue = valueExtractor.apply(value);
            listElementTitle.setLength(0);
            listElementTitle.append("[").append(i).append("]");
            if (value instanceof ToMessage) {
                this.lines.add(new Line(this.indent, listElementTitle));
                ((ToMessage)value).toMessage(this.indent + 1, this);
            } else {
                this.lines.add(new Line(this.indent, listElementTitle.toString(), Message.objectToString(displayValue)));
            }
            ++n2;
        }
        --this.indent;
        return this;
    }

    public <T> Message segmentIndexed(CharSequence title, int[] valueArray) {
        this.cachedResult = null;
        if (Objects.isNull(valueArray)) {
            this.lines.add(new Line(this.indent, title, "(null)"));
            return this;
        }
        if (valueArray.length <= 0) {
            this.lines.add(new Line(this.indent, title, "(empty)"));
            return this;
        }
        boolean first = true;
        StringBuilder intList = new StringBuilder().append("[ ");
        int[] nArray = valueArray;
        int n = valueArray.length;
        int n2 = 0;
        while (n2 < n) {
            int value = nArray[n2];
            if (!first) {
                intList.append(", ");
            }
            first = false;
            intList.append(Integer.toString(value));
            ++n2;
        }
        intList.append(" ]");
        this.lines.add(new Line(this.indent, title, intList));
        --this.indent;
        return this;
    }

    public <K, V> Message segmentMap(CharSequence title, Map<K, V> valueMap) {
        return this.segmentMap(title, valueMap, v -> v);
    }

    public <K, V> Message segmentMap(CharSequence title, Map<K, V> valueMap, Function<V, Object> valueExtractor) {
        this.cachedResult = null;
        if (Objects.isNull(valueMap)) {
            this.lines.add(new Line(this.indent, title, "(null)"));
            return this;
        }
        if (valueMap.isEmpty()) {
            this.lines.add(new Line(this.indent, title, "(empty)"));
            return this;
        }
        this.lines.add(new Line(this.indent++, title));
        StringBuilder listElementTitle = new StringBuilder();
        for (Map.Entry<K, V> entry : valueMap.entrySet()) {
            Object displayValue = valueExtractor.apply(entry.getValue());
            listElementTitle.setLength(0);
            listElementTitle.append("[").append(Message.objectToString(entry.getKey())).append("]");
            if (displayValue instanceof ToMessage) {
                this.lines.add(new Line(this.indent, listElementTitle));
                ((ToMessage)displayValue).toMessage(this.indent + 1, this);
                --this.indent;
                continue;
            }
            this.lines.add(new Line(this.indent, listElementTitle.toString(), Message.objectToString(displayValue)));
        }
        --this.indent;
        return this;
    }

    public Message segmentToMessage(CharSequence title, ToMessage toMessage) {
        this.title(title);
        if (toMessage != null) {
            this.indentInc();
            toMessage.toMessage(-1, this);
            this.indentDec();
        }
        return this;
    }

    public Message segmentToMessage(ToMessage toMessage) {
        if (Objects.isNull(toMessage)) {
            this.lines.add(new Line(-1, "(null)"));
            return this;
        }
        return toMessage.toMessage(-1, this);
    }

    public Message title(CharSequence title) {
        this.cachedResult = null;
        if (Objects.nonNull(title)) {
            this.lines.add(new Line(this.indent, title));
        }
        return this;
    }

    public Message toMessage(ToMessage value) {
        if (Objects.isNull(value)) {
            this.lines.add(new Line(-1, "(null)"));
            return this;
        }
        return value.toMessage(-1, this);
    }

    public String toString() {
        return Objects.nonNull(this.cachedResult) ? this.cachedResult : (this.cachedResult = this.toStringBuilder(null).toString());
    }

    public StringBuilder toStringBuilder(StringBuilder message) {
        int maxIndent = this.lines.stream().mapToInt(Line::getIndent).max().orElse(0);
        int[] indentColumnStartArray = new int[maxIndent + 1];
        this.lines.stream().filter(line -> LineType.SEGMENT.equals((Object)line.getLineType())).forEach(line -> {
            int indent = line.getIndent();
            indent = indent <= maxIndent ? (indent >= 0 ? indent : 0) : maxIndent;
            int titleLength = line.getSegmentTitleLength() + 2;
            nArray[indent] = indentColumnStartArray[indent] > titleLength ? indentColumnStartArray[indent] : titleLength;
        });
        int estimatedSize = this.lines.stream().mapToInt(line -> line.size(indentColumnStartArray)).sum();
        StringBuilder outMessage = Objects.nonNull(message) ? message : new StringBuilder(estimatedSize);
        this.lines.forEach(line -> line.append(outMessage, indentColumnStartArray));
        return outMessage;
    }

    private class Line {
        private final int indent;
        private final LineType lineType;
        private CharSequence title;
        private final CharSequence value;

        Line() {
            this.lineType = LineType.BLANK;
            this.indent = 0;
            this.title = "";
            this.value = "";
        }

        Line(CharSequence title) {
            this.lineType = LineType.BLOCK;
            this.indent = -1;
            this.title = Message.copy(title);
            this.value = "";
        }

        Line(int indent, CharSequence title) {
            this.lineType = LineType.TITLE;
            this.indent = indent;
            this.title = Message.copy(title);
            this.value = "";
        }

        Line(int indent, CharSequence title, CharSequence value) {
            this.lineType = LineType.SEGMENT;
            this.indent = indent;
            this.title = Message.copy(title);
            this.value = Message.copy(value);
        }

        Line(int indent, Line otherLine) {
            this.lineType = otherLine.lineType;
            this.indent = indent + (otherLine.indent >= 0 ? otherLine.indent : 0);
            this.title = Message.copy(otherLine.title);
            this.value = Message.copy(otherLine.value);
        }

        void append(StringBuilder message, int[] indentColumnStartArray) {
            switch (this.lineType) {
                case BLANK: {
                    message.append(Message.lineEnding);
                    return;
                }
                case BLOCK: {
                    String[] stringArray = this.getTitle().toString().split("\\v");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String line = stringArray[n2];
                        message.append(line).append(Message.lineEnding);
                        ++n2;
                    }
                    return;
                }
                case SEGMENT: {
                    int maxIndent = indentColumnStartArray.length - 1;
                    int indent = this.getIndent();
                    indent = indent <= maxIndent ? (indent >= 0 ? indent : 0) : maxIndent;
                    message.append(IndentedString.indentString(indent));
                    message.append(this.getTitle()).append(": ");
                    int space = indentColumnStartArray[indent] - this.title.length();
                    int i = 0;
                    while (i < space) {
                        message.append(" ");
                        ++i;
                    }
                    message.append(this.getValue()).append(Message.lineEnding);
                    return;
                }
                case TITLE: {
                    message.append(IndentedString.indentString(this.getIndent()));
                    message.append(this.getTitle()).append(Message.lineEnding);
                    return;
                }
            }
        }

        void appendTitle(CharSequence text) {
            switch (this.lineType) {
                case TITLE: {
                    if (Objects.isNull(this.title)) {
                        this.title = new StringBuilder(Message.newSize(text.length()));
                    } else if (this.title instanceof String) {
                        this.title = new StringBuilder(Message.newSize(this.title.length() + text.length())).append(this.title);
                    }
                    ((StringBuilder)this.title).append(text);
                }
            }
        }

        int getIndent() {
            return this.indent;
        }

        LineType getLineType() {
            return this.lineType;
        }

        int getSegmentTitleLength() {
            switch (this.lineType) {
                case SEGMENT: {
                    return this.title.length();
                }
            }
            return 0;
        }

        CharSequence getTitle() {
            assert (Objects.nonNull(this.title)) : "Message.Line::getTitle, member \"title\" is null.";
            return this.title;
        }

        CharSequence getValue() {
            return this.value;
        }

        int size(int[] indentColumnStartArray) {
            switch (this.lineType) {
                case BLANK: {
                    return lineEndingSize;
                }
                case BLOCK: {
                    return this.title.length() + lineEndingSize;
                }
                case SEGMENT: {
                    int maxIndent = indentColumnStartArray.length - 1;
                    int indent = this.getIndent();
                    indent = indent <= maxIndent ? (indent >= 0 ? indent : 0) : maxIndent;
                    return IndentedString.indentSize() * this.getIndent() + indentColumnStartArray[indent] + this.value.length() + lineEndingSize;
                }
                case TITLE: {
                    return IndentedString.indentSize() * this.getIndent() + this.title.length() + lineEndingSize;
                }
            }
            return 0;
        }
    }

    private static enum LineType {
        BLANK,
        BLOCK,
        SEGMENT,
        TITLE;

    }
}

