/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util.io.excel;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;

public class ExcelWorkbookWriter {
    private final OutputStream outputStream;
    private final Workbook workbook;
    private final WorkbookFormat format;
    private final Map<String, Sheet> sheets;
    private final Map<String, CellStyle> cellStyles;
    private Sheet activeSheet;
    private int defaultZoom = 100;

    public ExcelWorkbookWriter(OutputStream outputStream, WorkbookFormat format) {
        this.outputStream = outputStream;
        this.workbook = format.equals((Object)WorkbookFormat.XLS) ? new HSSFWorkbook() : new XSSFWorkbook();
        this.format = format;
        this.sheets = new HashMap<String, Sheet>();
        this.cellStyles = new HashMap<String, CellStyle>();
    }

    public void writeWorkbook() {
        try {
            this.workbook.write(this.outputStream);
        }
        catch (IOException ex) {
            System.out.println(ex);
        }
    }

    public void closeWorkbook() {
        try {
            this.workbook.close();
        }
        catch (IOException ex) {
            System.out.println(ex);
        }
    }

    public void createSheet(String sheetName) {
        Sheet sheet = this.workbook.createSheet(sheetName);
        sheet.setZoom(this.defaultZoom);
        this.sheets.put(sheetName, sheet);
        this.activeSheet = sheet;
    }

    public void setActiveSheet(String sheetName) {
        if (!this.sheets.containsKey(sheetName)) {
            throw new OseeArgumentException("No sheet found with name " + sheetName, new Object[0]);
        }
        this.activeSheet = this.sheets.get(sheetName);
    }

    public void setTabColor(CELLSTYLE style) {
        if (!this.isXSSF() || style == null || style.equals((Object)CELLSTYLE.NONE)) {
            return;
        }
        XSSFSheet sheet = (XSSFSheet)this.activeSheet;
        IndexedColors color = this.getIndexedColor(style);
        sheet.setTabColor(new XSSFColor(color, ((XSSFWorkbook)this.workbook).getStylesSource().getIndexedColors()));
    }

    public List<String> getSheetNames() {
        LinkedList<String> sheetNames = new LinkedList<String>();
        sheetNames.addAll(this.sheets.keySet());
        return sheetNames;
    }

    public void setColumnWidth(int index, int width) {
        this.checkActiveSheet();
        this.setColumnWidth(this.activeSheet.getSheetName(), index, width);
    }

    public void setColumnWidth(String sheetName, int index, int width) {
        if (!this.sheets.containsKey(sheetName)) {
            throw new OseeArgumentException("No sheet found with name " + sheetName, new Object[0]);
        }
        this.sheets.get(sheetName).setColumnWidth(index, width);
    }

    public void setColumnWidthInCharacters(int index, int numChars, int maxWidth) {
        this.checkActiveSheet();
        this.setColumnWidth(index, Math.min((int)((double)numChars * 1.2) * 256, maxWidth));
    }

    public int getColumnWidth(int index) {
        this.checkActiveSheet();
        return this.activeSheet.getColumnWidth(index);
    }

    public void addMergedRegion(String region) {
        this.checkActiveSheet();
        this.activeSheet.addMergedRegion(CellRangeAddress.valueOf((String)region));
    }

    public void addMergedRegion(int firstRow, int lastRow, int firstCol, int lastCol) {
        this.checkActiveSheet();
        this.activeSheet.addMergedRegion(new CellRangeAddress(firstRow, lastRow, firstCol, lastCol));
    }

    public void setRowHeight(int rowIndex, int height) {
        this.checkActiveSheet();
        Row row = this.activeSheet.getRow(rowIndex);
        if (row == null) {
            row = this.activeSheet.createRow(rowIndex);
        }
        row.setHeight((short)height);
    }

    public void autoSizeAllColumns(int numColumns) {
        this.checkActiveSheet();
        int i = 0;
        while (i < numColumns) {
            this.activeSheet.autoSizeColumn(i);
            ++i;
        }
    }

    public void setDefaultZoom(int scale) {
        this.defaultZoom = scale;
    }

    public void setZoom(int scale) {
        this.checkActiveSheet();
        this.activeSheet.setZoom(scale);
    }

    public void writeRow(int rowIndex, Object[] values, CELLSTYLE ... styles) {
        this.checkActiveSheet();
        int i = 0;
        while (i < values.length) {
            this.writeCell(rowIndex, i, values[i], styles);
            ++i;
        }
    }

    public void writeCell(int rowIndex, int cellIndex, Object value) {
        this.writeCell(rowIndex, cellIndex, value, CELLSTYLE.NONE);
    }

    public void writeCell(int rowIndex, int cellIndex, Object value, CELLSTYLE ... styles) {
        this.writeCell(rowIndex, cellIndex, value, "", HyperLinkType.SHEET, styles);
    }

    public void writeCell(int rowIndex, int cellIndex, Object value, String hyperlink, HyperLinkType hyperlinkType, CELLSTYLE ... styles) {
        Cell cell = this.getCell(rowIndex, cellIndex);
        cell.setCellStyle(this.createCellStyle(styles));
        if (!hyperlink.isEmpty()) {
            CreationHelper helper = this.workbook.getCreationHelper();
            Hyperlink link = helper.createHyperlink(hyperlinkType.equals((Object)HyperLinkType.SHEET) ? HyperlinkType.DOCUMENT : HyperlinkType.URL);
            link.setAddress(hyperlink);
            cell.setHyperlink(link);
        }
        if (value instanceof String) {
            cell.setCellValue((String)value);
        } else if (value instanceof Integer) {
            cell.setCellValue((double)((Integer)value).intValue());
        } else if (value instanceof Double) {
            cell.setCellValue(((Double)value).doubleValue());
        } else if (value instanceof Date) {
            String dateString = DateUtil.get((Date)value, "MM/dd/yyyy");
            cell.setCellValue(dateString);
        }
    }

    public void writeCellStringWithSuperscript(int rowIndex, int cellIndex, String value, int superscriptStart, int superscriptEnd, CELLSTYLE superscriptColor, CELLSTYLE ... styles) {
        Cell cell = this.getCell(rowIndex, cellIndex);
        CellStyle cellStyle = this.createCellStyle(styles);
        cell.setCellStyle(cellStyle);
        Font superscriptFont = this.workbook.createFont();
        superscriptFont.setTypeOffset((short)1);
        if (cellStyle.getFillForegroundColor() != IndexedColors.LIGHT_GREEN.getIndex() && superscriptColor.equals((Object)CELLSTYLE.GREEN)) {
            superscriptFont.setColor(IndexedColors.GREEN.getIndex());
            superscriptFont.setBold(true);
        } else if (cellStyle.getFillForegroundColor() != IndexedColors.LIGHT_YELLOW.getIndex() && superscriptColor.equals((Object)CELLSTYLE.YELLOW)) {
            superscriptFont.setColor(IndexedColors.GOLD.getIndex());
            superscriptFont.setBold(true);
        }
        XSSFRichTextString richText = new XSSFRichTextString(value);
        richText.applyFont(superscriptStart, superscriptEnd, superscriptFont);
        cell.setCellValue((RichTextString)richText);
    }

    private Cell getCell(int rowIndex, int cellIndex) {
        this.checkActiveSheet();
        Row row = this.activeSheet.getRow(rowIndex);
        if (row == null) {
            row = this.activeSheet.createRow(rowIndex);
        }
        return row.createCell(cellIndex);
    }

    private CellStyle createCellStyle(CELLSTYLE ... styles) {
        String styleString = "";
        CELLSTYLE[] cELLSTYLEArray = styles;
        int n = styles.length;
        int n2 = 0;
        while (n2 < n) {
            CELLSTYLE s = cELLSTYLEArray[n2];
            styleString = String.valueOf(styleString) + s.toString();
            ++n2;
        }
        CellStyle style = this.cellStyles.get(styleString);
        if (style != null) {
            return style;
        }
        style = this.workbook.createCellStyle();
        Font font = this.workbook.createFont();
        CELLSTYLE[] cELLSTYLEArray2 = styles;
        int n3 = styles.length;
        int n4 = 0;
        while (n4 < n3) {
            CELLSTYLE s = cELLSTYLEArray2[n4];
            switch (s) {
                case BOLD: {
                    font.setBold(true);
                    break;
                }
                case BORDER_ALL: {
                    style.setBorderTop(BorderStyle.THIN);
                    style.setBorderRight(BorderStyle.THIN);
                    style.setBorderBottom(BorderStyle.THIN);
                    style.setBorderLeft(BorderStyle.THIN);
                    break;
                }
                case BORDER_BOTTOM: {
                    style.setBorderBottom(BorderStyle.THIN);
                    break;
                }
                case BORDER_RIGHT: {
                    style.setBorderRight(BorderStyle.THIN);
                    break;
                }
                case BORDER_LEFT: {
                    style.setBorderLeft(BorderStyle.THIN);
                    break;
                }
                case BORDER_TOP: {
                    style.setBorderTop(BorderStyle.THIN);
                    break;
                }
                case CENTERH: {
                    style.setAlignment(HorizontalAlignment.CENTER);
                    break;
                }
                case CENTERV: {
                    style.setVerticalAlignment(VerticalAlignment.CENTER);
                    break;
                }
                case GREEN: {
                    style.setFillForegroundColor(this.getIndexedColor(s).getIndex());
                    style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                    break;
                }
                case HYPERLINK: {
                    font.setColor(IndexedColors.BLUE.getIndex());
                    font.setUnderline((byte)1);
                    break;
                }
                case LIGHT_BLUE: {
                    style.setFillForegroundColor(this.getIndexedColor(s).getIndex());
                    style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                    break;
                }
                case LIGHT_BLUE_XLSX: {
                    if (!this.isXSSF()) break;
                    byte[] rgb = new byte[]{-39, -31, -14};
                    XSSFColor color = new XSSFColor(rgb, this.getXSSFWorkbook().getStylesSource().getIndexedColors());
                    ((XSSFCellStyle)style).setFillForegroundColor(color);
                    style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                    break;
                }
                case LIGHT_GREY: {
                    style.setFillForegroundColor(this.getIndexedColor(s).getIndex());
                    style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                    break;
                }
                case LIGHT_RED: {
                    style.setFillForegroundColor(this.getIndexedColor(s).getIndex());
                    style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                    break;
                }
                case WRAP: {
                    style.setWrapText(true);
                    break;
                }
                case YELLOW: {
                    style.setFillForegroundColor(this.getIndexedColor(s).getIndex());
                    style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                    break;
                }
            }
            ++n4;
        }
        style.setFont(font);
        this.cellStyles.put(styleString, style);
        return style;
    }

    private IndexedColors getIndexedColor(CELLSTYLE style) {
        switch (style) {
            case GREEN: {
                return IndexedColors.LIGHT_GREEN;
            }
            case LIGHT_BLUE: {
                return IndexedColors.LIGHT_CORNFLOWER_BLUE;
            }
            case LIGHT_GREY: {
                return IndexedColors.GREY_25_PERCENT;
            }
            case LIGHT_RED: {
                return IndexedColors.CORAL;
            }
            case YELLOW: {
                return IndexedColors.LIGHT_YELLOW;
            }
        }
        return IndexedColors.WHITE;
    }

    public Sheet getActiveSheet() {
        return this.activeSheet;
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    private void checkActiveSheet() {
        if (this.activeSheet == null) {
            throw new OseeArgumentException("No sheet is active. Please create a sheet or set a sheet as active before writing.", new Object[0]);
        }
    }

    private boolean isXSSF() {
        return this.format.equals((Object)WorkbookFormat.XLSX);
    }

    private XSSFWorkbook getXSSFWorkbook() {
        return (XSSFWorkbook)this.workbook;
    }

    public static enum CELLSTYLE {
        BOLD,
        BORDER_ALL,
        BORDER_BOTTOM,
        BORDER_LEFT,
        BORDER_RIGHT,
        BORDER_TOP,
        CENTERH,
        CENTERV,
        GREEN,
        HYPERLINK,
        LIGHT_BLUE,
        LIGHT_GREY,
        LIGHT_RED,
        NONE,
        WRAP,
        LIGHT_BLUE_XLSX,
        YELLOW;

    }

    public static enum HyperLinkType {
        SHEET,
        URL;

    }

    public static enum WorkbookFormat {
        XLS,
        XLSX;

    }
}

