/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util.io.excel.pojo;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.io.excel.pojo.model.ECell;
import org.eclipse.osee.framework.jdk.core.util.io.excel.pojo.model.EFile;
import org.eclipse.osee.framework.jdk.core.util.io.excel.pojo.model.EHeaderCell;
import org.eclipse.osee.framework.jdk.core.util.io.excel.pojo.model.ERow;
import org.eclipse.osee.framework.jdk.core.util.io.excel.pojo.model.EWorksheet;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelXmlWriter;

public class PojoToExcelOperation {
    private final String excelFile;
    private final EFile eFile;

    public PojoToExcelOperation(EFile eFile, String excelFile) {
        this.eFile = eFile;
        this.excelFile = excelFile;
    }

    public File run() {
        File outFile = new File(this.excelFile);
        try {
            FileOutputStream outputStream = new FileOutputStream(outFile);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outputStream, "UTF-8");
            ExcelXmlWriter sheetWriter = new ExcelXmlWriter(writer);
            for (EWorksheet sheet : this.eFile.getWorkbook().getSheets()) {
                ArrayList<String> headers = new ArrayList<String>();
                for (EHeaderCell hCell : sheet.getHeader().getHcells()) {
                    headers.add(hCell.getName());
                }
                int columns = headers.size();
                sheetWriter.startSheet(sheet.getName(), columns);
                sheetWriter.writeRow(headers.toArray(new Object[columns]));
                for (ERow row : sheet.getRows()) {
                    ArrayList<String> rowVals = new ArrayList<String>();
                    for (ECell cell : row.getCells()) {
                        rowVals.add(cell.getValue());
                    }
                    sheetWriter.writeRow(rowVals.toArray(new Object[rowVals.size()]));
                }
                sheetWriter.endSheet();
            }
            sheetWriter.endWorkbook();
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (Exception ex) {
            this.eFile.getResults().errorf("Exception reading input: %s", Lib.exceptionToString(ex));
        }
        return outFile;
    }
}

