/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.workflow;

import java.util.Collection;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.eclipse.osee.ats.api.review.IAtsAbstractReview;
import org.eclipse.osee.ats.api.team.ChangeTypes;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.workflow.IAtsGoal;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.TeamWorkflowBranchCommitStatus;
import org.eclipse.osee.ats.api.workflow.TeamWorkflowDetails;
import org.eclipse.osee.ats.api.workflow.TeamWorkflowToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.framework.core.model.dto.DiffReportEndpointDto;
import org.eclipse.osee.framework.jdk.core.annotation.Swagger;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.jaxrs.mvc.IdentityView;

@Path(value="teamwf")
@Swagger
public interface AtsTeamWfEndpointApi {
    @GET
    @Path(value="{id}/changedata")
    @Produces(value={"application/json"})
    public List<ChangeItem> getChangeData(@PathParam(value="id") String var1);

    @GET
    @IdentityView
    @Path(value="{aiId}/version")
    @Produces(value={"application/json"})
    public Collection<IAtsVersion> getVersionsbyTeamDefinition(@PathParam(value="aiId") String var1, @QueryParam(value="sort") String var2);

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public IAtsTeamWorkflow getTeamWorkflow(@PathParam(value="id") String var1);

    @GET
    @Path(value="ids/{id}")
    @Produces(value={"application/json"})
    public Collection<IAtsTeamWorkflow> getTeamWorkflows(@PathParam(value="id") String var1);

    @GET
    @IdentityView
    @Path(value="{id}/changeTypes")
    @Produces(value={"application/json"})
    public Collection<ChangeTypes> getChangeTypes(@PathParam(value="id") String var1, @QueryParam(value="sort") String var2);

    @PUT
    @Path(value="{id}/addchangeids/{teamId}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public XResultData addChangeIds(@PathParam(value="id") String var1, @PathParam(value="teamId") String var2, List<String> var3);

    @GET
    @Path(value="{id}/goal")
    @Produces(value={"application/json"})
    public List<IAtsGoal> getGoals(@PathParam(value="id") String var1);

    @GET
    @Path(value="search")
    @Produces(value={"application/json"})
    public List<TeamWorkflowToken> search(@QueryParam(value="search") String var1, @QueryParam(value="originator") List<ArtifactId> var2, @QueryParam(value="assignee") List<ArtifactId> var3, @QueryParam(value="inProgressOnly") boolean var4, @QueryParam(value="searchByArtId") boolean var5, @QueryParam(value="pageNum") long var6, @QueryParam(value="count") long var8);

    @GET
    @Path(value="search/token")
    @Produces(value={"application/json"})
    public List<ArtifactToken> searchTokens(@QueryParam(value="search") String var1, @QueryParam(value="originator") List<ArtifactId> var2, @QueryParam(value="assignee") List<ArtifactId> var3, @QueryParam(value="inProgressOnly") boolean var4, @QueryParam(value="searchByArtId") boolean var5, @QueryParam(value="pageNum") long var6, @QueryParam(value="count") long var8);

    @GET
    @Path(value="search/count")
    @Produces(value={"application/json"})
    public int getSearchResultCount(@QueryParam(value="search") String var1, @QueryParam(value="originator") List<ArtifactId> var2, @QueryParam(value="assignee") List<ArtifactId> var3, @QueryParam(value="inProgressOnly") boolean var4, @QueryParam(value="searchByArtId") boolean var5);

    @GET
    @TeamWorkflowDetails
    @Path(value="details/{id}")
    @Produces(value={"application/json"})
    public IAtsTeamWorkflow getTeamWorkflowDetails(@PathParam(value="id") ArtifactId var1);

    @GET
    @Path(value="release/{release}")
    @Produces(value={"application/json"})
    public Collection<ArtifactToken> getWfByRelease(@PathParam(value="release") String var1);

    @GET
    @Path(value="release/id/{release}")
    @Produces(value={"application/json"})
    public Collection<ArtifactToken> getWfByReleaseById(@PathParam(value="release") ArtifactId var1);

    @PUT
    @Path(value="build/{build}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public XResultData relateReleaseToWorkflow(@PathParam(value="build") String var1, List<String> var2);

    @GET
    @Path(value="diff")
    @Produces(value={"application/json"})
    public DiffReportEndpointDto getDiffReportEndpoint();

    @GET
    @Path(value="{id}/review")
    @Produces(value={"application/json"})
    public Collection<IAtsAbstractReview> getReviews(@PathParam(value="id") String var1);

    @GET
    @Path(value="{id}/commitstatus")
    @Produces(value={"application/json"})
    public Collection<TeamWorkflowBranchCommitStatus> getBranchCommitStatus(@PathParam(value="id") ArtifactId var1);
}

