/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.model.change;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.RelationId;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.data.TupleTypeId;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.model.change.ChangeIgnoreType;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.framework.core.model.change.ChangeType;
import org.eclipse.osee.framework.core.model.change.ChangeVersion;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;

public final class ChangeItemUtil {
    private ChangeItemUtil() {
    }

    public static ChangeItem newArtifactChange(ArtifactId artId, ArtifactTypeId artTypeId, GammaId currentSourceGammaId, ModificationType currentSourceModType, ApplicabilityToken appToken, TransactionToken txToken) {
        ChangeItem item = new ChangeItem();
        item.setChangeType(ChangeType.Artifact);
        item.setItemId((Id)artId);
        item.setItemTypeId((Id)artTypeId);
        item.setSynthetic(false);
        ChangeVersion current = item.getCurrentVersion();
        current.setGammaId(currentSourceGammaId);
        current.setModType(currentSourceModType);
        current.setApplicabilityToken(appToken);
        current.setTransactionToken(txToken);
        item.setArtId(artId);
        return item;
    }

    public static ChangeItem newAttributeChange(AttributeId attrId, AttributeTypeId attrTypeId, ArtifactId artId, GammaId currentSourceGammaId, ModificationType currentSourceModType, String value, String uri, ApplicabilityToken appToken, TransactionToken txToken) {
        ChangeItem item = new ChangeItem();
        item.setChangeType(ChangeType.Attribute);
        item.setItemId((Id)attrId);
        item.setItemTypeId((Id)attrTypeId);
        item.setSynthetic(false);
        ChangeVersion current = item.getCurrentVersion();
        current.setGammaId(currentSourceGammaId);
        current.setModType(currentSourceModType);
        current.setApplicabilityToken(appToken);
        current.setTransactionToken(txToken);
        current.setUri(uri);
        item.setArtId(artId);
        item.getCurrentVersion().setValue(value);
        return item;
    }

    public static ChangeItem newRelationChange(RelationId relLinkId, RelationTypeToken relTypeId, GammaId currentSourceGammaId, ModificationType currentSourceModType, ArtifactId aArtId, ArtifactId bArtId, String rationale, ApplicabilityToken appToken, TransactionToken txToken) {
        ChangeItem item = new ChangeItem();
        item.setChangeType(ChangeType.Relation);
        item.setItemId((Id)relLinkId);
        item.setItemTypeId((Id)relTypeId);
        item.setSynthetic(false);
        ChangeVersion current = item.getCurrentVersion();
        current.setGammaId(currentSourceGammaId);
        current.setModType(currentSourceModType);
        current.setApplicabilityToken(appToken);
        current.setTransactionToken(txToken);
        item.setRelOrder(0);
        item.setArtId(aArtId);
        item.setArtIdB(bArtId);
        item.getCurrentVersion().setValue(rationale);
        return item;
    }

    public static ChangeItem newRelationChange2(RelationTypeToken relTypeId, GammaId currentSourceGammaId, ModificationType currentSourceModType, ArtifactId aArtId, ArtifactId bArtId, ArtifactId relArtId, int relOrder, ApplicabilityToken appToken, TransactionToken txToken) {
        ChangeItem item = new ChangeItem();
        item.setChangeType(ChangeType.Relation);
        item.setRelOrder(relOrder);
        item.setItemId((Id)currentSourceGammaId);
        item.setItemTypeId((Id)relTypeId);
        item.setSynthetic(false);
        ChangeVersion current = item.getCurrentVersion();
        current.setGammaId(currentSourceGammaId);
        current.setModType(currentSourceModType);
        current.setApplicabilityToken(appToken);
        current.setTransactionToken(txToken);
        item.setArtId(aArtId);
        item.setArtIdB(bArtId);
        item.getCurrentVersion().setValue(String.valueOf(relArtId.toString()) + "," + relOrder);
        return item;
    }

    public static ChangeItem newTupleChange(TupleTypeId tupleTypeId, GammaId gammaId, ApplicabilityToken appToken, ModificationType currentSourceModType, TransactionToken txToken, Long ... e) {
        ChangeItem item = new ChangeItem();
        item.setChangeType(ChangeType.Tuple);
        item.setItemId((Id)gammaId);
        item.setItemTypeId((Id)tupleTypeId);
        item.setSynthetic(false);
        ChangeVersion current = item.getCurrentVersion();
        current.setGammaId(gammaId);
        current.setModType(currentSourceModType);
        current.setApplicabilityToken(appToken);
        current.setTransactionToken(txToken);
        if (e.length == 2) {
            item.getCurrentVersion().setValue(String.format("Tuple2|%s, %s", e[0], e[1]));
        } else if (e.length == 3) {
            item.getCurrentVersion().setValue(String.format("Tuple3|%s, %s, %s", e[0], e[1], e[2]));
        } else if (e.length == 4) {
            item.getCurrentVersion().setValue(String.format("Tuple4|%s, %s, %s, %s", e[0], e[1], e[2], e[3]));
        }
        return item;
    }

    public static ChangeVersion getStartingVersion(ChangeItem item) {
        if (item == null) {
            throw new OseeArgumentException("ChangeItem cannot be null", new Object[0]);
        }
        ChangeVersion toReturn = item.getBaselineVersion();
        if (!(toReturn.isValid() || (toReturn = item.getFirstNonCurrentChange()).isValid() || (toReturn = item.getCurrentVersion()).isValid())) {
            throw new OseeStateException("Cannot find a valid starting point for change item: %s", new Object[]{item});
        }
        return toReturn;
    }

    public static void copy(ChangeVersion source, ChangeVersion dest) {
        Conditions.checkNotNull((Object)source, (String)"Source ChangeVersion");
        Conditions.checkNotNull((Object)dest, (String)"Destination ChangeVersion");
        dest.copy(source);
    }

    public static boolean isModType(ChangeVersion changeVersion, ModificationType matchModType) {
        return changeVersion != null && changeVersion.getModType().equals(matchModType);
    }

    public static boolean isNew(ChangeVersion changeVersion) {
        return ChangeItemUtil.isModType(changeVersion, ModificationType.NEW);
    }

    public static boolean isIntroduced(ChangeVersion changeVersion) {
        return ChangeItemUtil.isModType(changeVersion, ModificationType.INTRODUCED);
    }

    public static boolean isDeleted(ChangeVersion changeVersion) {
        return changeVersion != null && changeVersion.getModType().isDeleted();
    }

    public static boolean isArtifactDeleted(ChangeVersion changeVersion) {
        return changeVersion != null && changeVersion.getModType().isArtifactDeleted();
    }

    public static boolean wasNewOnSource(ChangeItem changeItem) {
        return ChangeItemUtil.isNew(changeItem.getFirstNonCurrentChange()) || ChangeItemUtil.isNew(changeItem.getCurrentVersion());
    }

    public static boolean wasIntroducedOnSource(ChangeItem changeItem) {
        return ChangeItemUtil.isIntroduced(changeItem.getFirstNonCurrentChange()) || ChangeItemUtil.isIntroduced(changeItem.getCurrentVersion());
    }

    public static boolean hasBeenReplacedWithVersion(ChangeItem changeItem) {
        boolean results = ChangeItemUtil.areGammasEqual(changeItem.getCurrentVersion(), changeItem.getBaselineVersion()) && ChangeItemUtil.isModType(changeItem.getCurrentVersion(), ModificationType.MODIFIED);
        return results;
    }

    public static boolean isAlreadyOnDestination(ChangeItem changeItem) {
        return ChangeItemUtil.areGammasEqual(changeItem.getCurrentVersion(), changeItem.getDestinationVersion()) && ChangeItemUtil.areModTypesEqual(changeItem.getCurrentVersion(), changeItem.getDestinationVersion()) && ChangeItemUtil.areApplicabilitiesEqual(changeItem.getCurrentVersion(), changeItem.getDestinationVersion());
    }

    public static boolean areModTypesEqual(ChangeVersion object1, ChangeVersion object2) {
        boolean result = false;
        if (object1 == null && object2 == null) {
            result = true;
        } else if (object1 != null && object2 != null) {
            result = object1.getModType().equals(object2.getModType());
        }
        return result;
    }

    public static boolean areGammasEqual(ChangeVersion object1, ChangeVersion object2) {
        boolean result = false;
        if (object1 == null && object2 == null) {
            result = true;
        } else if (object1 != null && object2 != null) {
            if (object1.getGammaId() == object2.getGammaId()) {
                result = true;
            } else if (object1.getGammaId() != null) {
                result = object1.getGammaId().equals(object2.getGammaId());
            }
        }
        return result;
    }

    public static boolean areApplicabilitiesEqual(ChangeVersion object1, ChangeVersion object2) {
        boolean result = false;
        if (object1 == null && object2 == null) {
            result = true;
        } else if (object1 != null && object2 != null) {
            if (object1.getApplicabilityToken() == object2.getApplicabilityToken()) {
                result = true;
            } else if (object1.getApplicabilityToken() != null) {
                result = object1.getApplicabilityToken().equals((Object)object2.getApplicabilityToken());
            }
        }
        return result;
    }

    public static ChangeItem splitForApplicability(ChangeItem source) {
        ChangeItem dest = new ChangeItem();
        dest.copy(source);
        dest.setApplicabilityCopy(true);
        return dest;
    }

    public static void checkAndSetIgnoreCase(ChangeItem changeItem) {
        boolean changed = false;
        changed |= ChangeItemUtil.createdAndDeleted(changeItem);
        changed |= ChangeItemUtil.wasAlreadyOnDestination(changeItem);
        changed |= ChangeItemUtil.deletedAndDoesNotExistInDestination(changeItem);
        changed |= ChangeItemUtil.deletedOnDestAndNotResurrected(changeItem);
        if (!(changed |= ChangeItemUtil.replacedWithVerAndNotRessurected(changeItem))) {
            changeItem.setIgnoreType(ChangeIgnoreType.NONE);
        }
    }

    public static boolean wasAlreadyOnDestination(ChangeItem changeItem) {
        if (ChangeItemUtil.isAlreadyOnDestination(changeItem)) {
            changeItem.setIgnoreType(ChangeIgnoreType.ALREADY_ON_DESTINATION);
            return true;
        }
        return false;
    }

    public static boolean createdAndDeleted(ChangeItem changeItem) {
        if (ChangeItemUtil.wasCreatedAndDeleted(changeItem)) {
            changeItem.setIgnoreType(ChangeIgnoreType.CREATED_AND_DELETED);
            return true;
        }
        return false;
    }

    public static boolean deletedAndDoesNotExistInDestination(ChangeItem changeItem) {
        if (!changeItem.getDestinationVersion().isValid() && ChangeItemUtil.isDeleted(changeItem.getCurrentVersion())) {
            changeItem.setIgnoreType(ChangeIgnoreType.DELETED_AND_DNE_ON_DESTINATION);
            return true;
        }
        return false;
    }

    public static boolean beenDeletedInDestination(ChangeItem changeItem) {
        if (ChangeItemUtil.hasBeenDeletedInDestination(changeItem)) {
            changeItem.setIgnoreType(ChangeIgnoreType.DELETED_ON_DESTINATION);
            return true;
        }
        return false;
    }

    public static boolean deletedOnDestAndNotResurrected(ChangeItem changeItem) {
        if (ChangeItemUtil.hasBeenDeletedInDestination(changeItem) && !ChangeItemUtil.isResurrected(changeItem)) {
            changeItem.setIgnoreType(ChangeIgnoreType.DELETED_ON_DEST_AND_NOT_RESURRECTED);
            return true;
        }
        return false;
    }

    public static boolean replacedWithVerAndNotRessurected(ChangeItem changeItem) {
        if (ChangeItemUtil.hasBeenReplacedWithVersion(changeItem) && !ChangeItemUtil.isResurrected(changeItem) && !ChangeItemUtil.hasApplicabilityOnlyChange(changeItem)) {
            changeItem.setIgnoreType(ChangeIgnoreType.REPLACED_WITH_VERSION_AND_NOT_RESURRECTED);
            return true;
        }
        return false;
    }

    public static boolean resurrected(ChangeItem changeItem) {
        if (ChangeItemUtil.isResurrected(changeItem)) {
            changeItem.setIgnoreType(ChangeIgnoreType.RESURRECTED);
            return true;
        }
        return false;
    }

    public static boolean wasCreatedAndDeleted(ChangeItem changeItem) {
        return !changeItem.getBaselineVersion().isValid() && ChangeItemUtil.isDeleted(changeItem.getCurrentVersion());
    }

    public static boolean isDeletedAndDoesNotExistInDestination(ChangeItem changeItem) {
        return !changeItem.getDestinationVersion().isValid() && ChangeItemUtil.isDeleted(changeItem.getCurrentVersion());
    }

    public static boolean isResurrected(ChangeItem changeItem) {
        return changeItem.getBaselineVersion().isValid() && ChangeItemUtil.isDeleted(changeItem.getBaselineVersion());
    }

    public static boolean hasBeenDeletedInDestination(ChangeItem changeItem) {
        return changeItem.getDestinationVersion().isValid() && ChangeItemUtil.isDeleted(changeItem.getDestinationVersion());
    }

    public static boolean hasValueChange(ChangeItem changeItem) {
        return changeItem.getCurrentVersion().isValid() && changeItem.getDestinationVersion().isValid() && changeItem.getCurrentVersion().getValue() != null && changeItem.getDestinationVersion().getValue() != null && !changeItem.getCurrentVersion().getValue().equals(changeItem.getDestinationVersion().getValue());
    }

    public static boolean hasApplicabilityChange(ChangeItem changeItem) {
        if (changeItem.isApplicabilityCopy()) {
            return true;
        }
        if (changeItem.getCurrentVersion().isValid() && changeItem.getDestinationVersion().isValid() && !ChangeItemUtil.areApplicabilitiesEqual(changeItem.getCurrentVersion(), changeItem.getDestinationVersion())) {
            return true;
        }
        return changeItem.getCurrentVersion().isValid() && !changeItem.getDestinationVersion().isValid();
    }

    public static boolean hasApplicabilityOnlyChange(ChangeItem changeItem) {
        if (changeItem.isApplicabilityCopy()) {
            return false;
        }
        if (ChangeItemUtil.isDeleted(changeItem.getCurrentVersion())) {
            return false;
        }
        return changeItem.getCurrentVersion().isValid() && changeItem.getDestinationVersion().isValid() && !ChangeItemUtil.areApplicabilitiesEqual(changeItem.getCurrentVersion(), changeItem.getDestinationVersion());
    }

    public static void computeNetChanges(List<ChangeItem> changes) {
        for (ChangeItem change : changes) {
            ChangeItemUtil.checkAndSetIgnoreCase(change);
            if (change.getNetChange().getModType().equals(ModificationType.MERGED)) {
                if (!ChangeItemUtil.isDeleted(change.getCurrentVersion())) continue;
                change.getNetChange().copy(change.getCurrentVersion());
                continue;
            }
            ModificationType netModType = ChangeItemUtil.calculateNetWithDestinationBranch(change);
            if (netModType == null) {
                throw new OseeStateException("Net Mod Type was null", new Object[0]);
            }
            change.getNetChange().copy(change.getCurrentVersion());
            change.getNetChange().setModType(netModType);
        }
    }

    public static List<ChangeItem> computeNetChangesAndFilter(List<ChangeItem> changes) {
        ChangeItemUtil.computeNetChanges(changes);
        ArrayList<ChangeItem> allowedChanges = new ArrayList<ChangeItem>();
        for (ChangeItem item : changes) {
            if (!ChangeItemUtil.isAllowableChange(item.getIgnoreType())) continue;
            allowedChanges.add(item);
        }
        return allowedChanges;
    }

    private static boolean isAllowableChange(ChangeIgnoreType type) {
        return type.isNone() || type.isResurrected();
    }

    private static ModificationType calculateNetWithDestinationBranch(ChangeItem change) {
        ModificationType netModType = change.getCurrentVersion().getModType();
        if (change.getDestinationVersion().isValid() && (change.getBaselineVersion().isValid() || change.getFirstNonCurrentChange().isValid())) {
            netModType = change.getCurrentVersion().getModType();
        } else if (ChangeItemUtil.wasNewOnSource(change)) {
            netModType = ModificationType.NEW;
        } else if (ChangeItemUtil.wasIntroducedOnSource(change)) {
            netModType = ModificationType.INTRODUCED;
        } else if (!change.getDestinationVersion().isValid()) {
            netModType = change.getBaselineVersion().isValid() ? ModificationType.INTRODUCED : ModificationType.NEW;
        }
        return netModType;
    }

    public static Collection<ArtifactId> getArtifacts(Collection<ChangeItem> changes, ChangeType changeItemType, ModificationType ... modificationType) {
        ArrayList<ArtifactId> artifacts = new ArrayList<ArtifactId>();
        block0: for (ChangeItem change : changes) {
            if (!change.getChangeType().equals((Object)changeItemType)) continue;
            ModificationType changeModType = change.getCurrentVersion().getModType();
            ModificationType[] modificationTypeArray = modificationType;
            int n = modificationType.length;
            int n2 = 0;
            while (n2 < n) {
                ModificationType modType = modificationTypeArray[n2];
                if (changeModType.equals(modType) && !artifacts.contains(change.getArtId())) {
                    artifacts.add(change.getArtId());
                    continue block0;
                }
                ++n2;
            }
        }
        return artifacts;
    }
}

