/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.selection;

import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.egit.core.internal.SafeRunnable;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public abstract class AbstractSelectionProvider
implements IPostSelectionProvider {
    private final CopyOnWriteArrayList<ISelectionChangedListener> selectionListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ISelectionChangedListener> postSelectionListeners = new CopyOnWriteArrayList();

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.addIfAbsent(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        this.postSelectionListeners.addIfAbsent(listener);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        this.postSelectionListeners.remove(listener);
    }

    protected CopyOnWriteArrayList<ISelectionChangedListener> getSelectionListeners() {
        return this.selectionListeners;
    }

    protected CopyOnWriteArrayList<ISelectionChangedListener> getPostSelectionListeners() {
        return this.postSelectionListeners;
    }

    protected void fireSelectionChanged(CopyOnWriteArrayList<ISelectionChangedListener> listeners) {
        if (listeners.isEmpty()) {
            return;
        }
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        for (ISelectionChangedListener listener : listeners) {
            SafeRunnable.run(() -> listener.selectionChanged(event));
        }
    }
}

