/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize;

import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeData;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeDataSet;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.dialogs.CompareTreeView;
import org.eclipse.egit.ui.internal.synchronize.GitModelSynchronize;
import org.eclipse.egit.ui.internal.synchronize.GitSynchronizer;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class DefaultGitSynchronizer
implements GitSynchronizer {
    protected boolean canCompareDirectly(IResource[] resources) {
        if (resources.length == 1) {
            IResource resource = resources[0];
            if (resource instanceof IFile) {
                return this.canCompareDirectly((IFile)resource);
            }
            IPath location = resource.getLocation();
            if (location != null && Files.isSymbolicLink(location.toFile().toPath())) {
                return true;
            }
        }
        return false;
    }

    protected boolean canCompareDirectly(@NonNull IFile file) {
        return true;
    }

    @Override
    public void compare(IResource[] resources, @NonNull Repository repository, String leftRev, String rightRev, boolean includeLocal, IWorkbenchPage page) throws IOException {
        if (this.canCompareDirectly(resources)) {
            if (includeLocal) {
                CompareUtils.compareWorkspaceWithRef(repository, resources[0], rightRev, page);
            } else {
                IResource file = resources[0];
                Assert.isNotNull((Object)file);
                RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)file);
                if (mapping == null) {
                    Activator.error(NLS.bind((String)UIText.GitHistoryPage_errorLookingUpPath, (Object)file.getLocation(), (Object)repository), null);
                    return;
                }
                String gitPath = mapping.getRepoRelativePath(file);
                CompareUtils.compareBetween(repository, gitPath, leftRev, rightRev, page);
            }
        } else {
            this.synchronize(resources, repository, leftRev, rightRev, includeLocal);
        }
    }

    @Override
    public void compare(IFile file, Repository repository, String leftPath, String rightPath, String leftRev, String rightRev, boolean includeLocal, IWorkbenchPage page) throws IOException {
        if (this.canCompareDirectly(file)) {
            if (includeLocal) {
                CompareUtils.compareWorkspaceWithRef(repository, (IResource)file, rightRev, page);
            } else {
                CompareUtils.compareBetween(repository, leftPath, rightPath, leftRev, rightRev, page);
            }
        } else {
            this.synchronize(new IResource[]{file}, repository, leftRev, rightRev, includeLocal);
        }
    }

    protected void synchronize(IResource[] resources, Repository repository, String leftRev, String rightRev, boolean includeLocal) throws IOException {
        if (rightRev.equals("Index")) {
            this.openGitTreeCompare(resources, leftRev, "%%%INDEX%%%", includeLocal);
        } else if (leftRev.equals("Index")) {
            HashSet<IResource> resSet = new HashSet<IResource>(Arrays.asList(resources));
            GitSynchronizeData gsd = new GitSynchronizeData(repository, leftRev, rightRev, true, resSet);
            GitModelSynchronize.launch(new GitSynchronizeDataSet(gsd), resources);
        } else {
            HashSet<IResource> resSet = new HashSet<IResource>(Arrays.asList(resources));
            GitSynchronizeData gsd = new GitSynchronizeData(repository, leftRev, rightRev, includeLocal, resSet);
            GitModelSynchronize.launch(new GitSynchronizeDataSet(gsd), resources);
        }
    }

    protected void openGitTreeCompare(final IResource[] resources, final String leftRev, final String rightRev, final boolean includeLocal) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    CompareTreeView view = (CompareTreeView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.egit.ui.CompareTreeView");
                    if (includeLocal) {
                        view.setInput(resources, rightRev);
                    } else {
                        view.setInput(resources, leftRev, rightRev);
                    }
                }
                catch (PartInitException e) {
                    Activator.handleError(e.getMessage(), e, true);
                }
            }
        });
    }
}

