/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.client;

import java.util.List;
import java.util.Properties;
import org.eclipse.osee.framework.core.client.ICredentialProvider;
import org.eclipse.osee.framework.core.client.internal.InternalClientSessionManager;
import org.eclipse.osee.framework.core.data.IdeClientSession;
import org.eclipse.osee.framework.core.data.OseeSessionGrant;
import org.eclipse.osee.framework.core.data.UserToken;

public class ClientSessionManager {
    private ClientSessionManager() {
    }

    public static final String getStatusId() {
        return "Session Manager";
    }

    public static boolean isSessionValid() {
        return InternalClientSessionManager.getInstance().isSessionValid();
    }

    public static void ensureSessionCreated() {
        InternalClientSessionManager.getInstance().ensureSessionCreated();
    }

    private static OseeSessionGrant getSessionGrant() {
        return InternalClientSessionManager.getInstance().getOseeSessionGrant();
    }

    public static IdeClientSession getSession() {
        return InternalClientSessionManager.getInstance().getOseeSession();
    }

    public static UserToken getCurrentUserToken() {
        return ClientSessionManager.getSessionGrant().getUserToken();
    }

    public static String getSessionId() {
        return ClientSessionManager.getSessionGrant().getSessionId();
    }

    public static String getClientName() {
        return ClientSessionManager.getSession().getClientName();
    }

    public static String getClientPort() {
        return ClientSessionManager.getSession().getClientPort();
    }

    public static String getDataStoreLoginName() {
        return ClientSessionManager.getSessionGrant().getDbLogin();
    }

    public static String getDataStoreDriver() {
        return ClientSessionManager.getSessionGrant().getDbDriver();
    }

    public static String getDataStoreName() {
        return ClientSessionManager.getSessionGrant().getDbDatabaseName();
    }

    public static String getDataStorePath() {
        return ClientSessionManager.getSessionGrant().getDataStorePath();
    }

    public static boolean isProductionDataStore() {
        return ClientSessionManager.getSessionGrant().isDbIsProduction();
    }

    public static Properties getSqlProperties() {
        return ClientSessionManager.getSessionGrant().getSqlProperties();
    }

    public static List<String> getAuthenticationProtocols() {
        return InternalClientSessionManager.getInstance().getAuthenticationProtocols();
    }

    public static void authenticateAsAnonymous() {
        InternalClientSessionManager.getInstance().authenticateAsAnonymous();
    }

    public static void authenticate(ICredentialProvider credentialProvider) {
        InternalClientSessionManager.getInstance().authenticate(credentialProvider);
    }

    public static void releaseSession() {
        InternalClientSessionManager.getInstance().releaseSession();
    }

    public static String getDatabaseInfo() {
        return ClientSessionManager.getSessionGrant().toString();
    }

    public static IdeClientSession getSafeSession() {
        return InternalClientSessionManager.getInstance().getSafeSession();
    }
}

