/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.client;

import java.util.Objects;
import javax.ws.rs.core.Response;
import org.eclipse.osee.define.rest.api.toggles.TogglesEndpoint;
import org.eclipse.osee.framework.core.util.toggles.ToggleAccessor;
import org.eclipse.osee.jaxrs.OseeWebApplicationException;

public class TogglesClientImpl {
    private static TogglesClientImpl togglesClientImpl = null;
    private final TogglesEndpoint togglesEndpoint;

    private TogglesClientImpl(TogglesEndpoint togglesEndpoint) {
        this.togglesEndpoint = togglesEndpoint;
    }

    public static synchronized TogglesClientImpl create(TogglesEndpoint togglesEndpoint) {
        return Objects.isNull(togglesClientImpl) ? (togglesClientImpl = new TogglesClientImpl(Objects.requireNonNull(togglesEndpoint))) : togglesClientImpl;
    }

    public String getDataBaseToggle(String name) {
        try {
            return this.togglesEndpoint.getToggle(name);
        }
        catch (Exception e) {
            throw new OseeWebApplicationException((Throwable)e, (Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, "Exception in \"getNoTags\" request.", new Object[0]);
        }
    }

    public static ToggleAccessor getDataBaseToggleAccessor() {
        if (Objects.isNull(togglesClientImpl)) {
            TogglesClientImpl.create(null);
        }
        return new ToggleAccessor(){

            public String getToggle(String name) {
                return togglesClientImpl.getDataBaseToggle(name);
            }

            public String toString() {
                return "Client dataBaseToggleAccessor";
            }
        };
    }
}

