/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.column;

import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.column.AtsColumnTokensDefault;
import org.eclipse.osee.ats.api.column.AtsCoreCodeColumnToken;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.core.column.model.AtsCoreCodeColumn;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class StateColumn
extends AtsCoreCodeColumn {
    public StateColumn(AtsApi atsApi) {
        super((AtsCoreCodeColumnToken)AtsColumnTokensDefault.StateColumn, atsApi);
    }

    @Override
    public String getText(IAtsObject atsObject) throws Exception {
        if (atsObject instanceof IAtsWorkItem) {
            IAtsWorkItem workItem = (IAtsWorkItem)atsObject;
            String isBlocked = (String)this.atsApi.getAttributeResolver().getSoleAttributeValue(atsObject, (AttributeTypeToken)AtsAttributeTypes.BlockedReason, (Object)"");
            String isHold = (String)this.atsApi.getAttributeResolver().getSoleAttributeValue(atsObject, (AttributeTypeToken)AtsAttributeTypes.HoldReason, (Object)"");
            if (Strings.isValid((String)isBlocked) && Strings.isValid((String)isHold)) {
                String hold = String.valueOf(((IAtsWorkItem)atsObject).getCurrentStateName()) + " (Hold)";
                String block = " " + ((IAtsWorkItem)atsObject).getCurrentStateName() + " (Blocked)";
                return String.valueOf(hold) + block;
            }
            String currStateName = workItem.getCurrentStateName();
            if (Strings.isValid((String)isBlocked)) {
                return String.valueOf(currStateName) + " (Blocked)";
            }
            if (Strings.isValid((String)isHold)) {
                return String.valueOf(currStateName) + " (Hold)";
            }
            return currStateName;
        }
        return "";
    }
}

