/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Collections;

public class WorkflowTypesTestOperation {
    List<AttributeTypeToken> attrTypeHintChecked = new ArrayList<AttributeTypeToken>();
    Map<String, AttributeTypeToken> typeDisplayNameToToken = new HashMap<String, AttributeTypeToken>();
    XResultData rd = new XResultData();
    List<AttributeTypeToken> ignoreTypes = Collections.asList((Object[])new AttributeTypeToken[]{CoreAttributeTypes.Description});

    public XResultData run() {
        this.testArtType(AtsArtifactTypes.AbstractWorkflowArtifact);
        return this.rd;
    }

    private void testArtType(ArtifactTypeToken artType) {
        for (AttributeTypeToken attrType : artType.getValidAttributeTypes()) {
            if (this.attrTypeHintChecked.contains(attrType) || this.ignoreTypes.contains(attrType)) continue;
            String unqualName = attrType.getUnqualifiedName();
            if (this.typeDisplayNameToToken.containsKey(unqualName)) {
                AttributeTypeToken otherAttrType = this.typeDisplayNameToToken.get(unqualName);
                this.rd.errorf("Workflow Attr Type %s on Art Type %s has same unqualified name as %s\n", new Object[]{attrType.toStringWithId(), artType.toStringWithId(), otherAttrType.toStringWithId()});
            } else {
                this.typeDisplayNameToToken.put(unqualName, attrType);
            }
            this.attrTypeHintChecked.add(attrType);
        }
        for (ArtifactTypeToken childArtType : artType.getAllDescendantTypes()) {
            this.testArtType(childArtType);
        }
    }
}

