/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.query;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.query.AtsSearchData;
import org.eclipse.osee.ats.api.query.AtsSearchDataResults;
import org.eclipse.osee.ats.api.query.AtsSearchUserType;
import org.eclipse.osee.ats.api.review.IAtsAbstractReview;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.AttributeValue;
import org.eclipse.osee.ats.api.util.AttributeValues;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.version.Version;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.WorkItemType;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class AtsSearchDataVersionSearch {
    private final AtsSearchData data;
    private final AtsApi atsApi;
    private final XResultData rd;

    public AtsSearchDataVersionSearch(AtsSearchData data, AtsApi atsApi) {
        this.atsApi = atsApi;
        this.data = data.copy();
        this.rd = new XResultData();
    }

    public AtsSearchDataResults performSearch() {
        Set<IAtsWorkItem> results = new HashSet<IAtsWorkItem>();
        Long versionId = this.data.getVersionId();
        Version version = this.atsApi.getVersionService().getVersionById(ArtifactId.valueOf((Long)versionId));
        if (version == null) {
            this.rd.errorf("Invalid use of AtsSearchDataVersion, must specify Version; found ", new Object[]{versionId});
            return new AtsSearchDataResults(Collections.emptyList(), this.rd);
        }
        List workItemTypes = this.data.getWorkItemTypes();
        if (workItemTypes.contains(WorkItemType.Goal)) {
            this.rd.errorf("Invalid Goal Type for Version Search", new Object[0]);
            return new AtsSearchDataResults(Collections.emptyList(), this.rd);
        }
        if (workItemTypes.contains(WorkItemType.AgileBacklog) || workItemTypes.contains(WorkItemType.AgileSprint)) {
            this.rd.errorf("Invalid Agile Type(s) for Version Search", new Object[0]);
            return new AtsSearchDataResults(Collections.emptyList(), this.rd);
        }
        for (IAtsTeamWorkflow teamWf : this.atsApi.getVersionService().getTargetedForTeamWorkflows((IAtsVersion)version)) {
            results.addAll(this.addWorkItems(teamWf));
        }
        results = this.filterStateType(this.data, results);
        results = this.filterStateName(this.data, results);
        results = this.filterChangeType(this.data, results);
        results = this.filterUserType(this.data, results);
        results = this.filterAttrValues(this.data, results);
        List arts = org.eclipse.osee.framework.jdk.core.util.Collections.castAll(AtsObjects.getArtifacts(results));
        return new AtsSearchDataResults((Collection)arts, this.rd);
    }

    private Collection<IAtsWorkItem> addWorkItems(IAtsTeamWorkflow teamWf) {
        HashSet<IAtsWorkItem> results = new HashSet<IAtsWorkItem>();
        if (!this.matchTeamDefs(teamWf) && !this.matchAis(teamWf)) {
            return results;
        }
        if (this.data.getWorkItemTypes().contains(WorkItemType.TeamWorkflow)) {
            results.add((IAtsWorkItem)teamWf);
        }
        if (this.data.getWorkItemTypes().contains(WorkItemType.Task)) {
            results.addAll(this.atsApi.getTaskService().getTasks(teamWf));
        }
        boolean includeDecRevs = this.data.getWorkItemTypes().contains(WorkItemType.DecisionReview);
        boolean includePeerRevs = this.data.getWorkItemTypes().contains(WorkItemType.PeerReview);
        if (includePeerRevs || includeDecRevs) {
            for (IAtsAbstractReview rev : this.atsApi.getReviewService().getReviews(teamWf)) {
                if (rev.isDecisionReview() && includeDecRevs) {
                    results.add((IAtsWorkItem)rev);
                    continue;
                }
                if (!rev.isPeerReview() || !includePeerRevs) continue;
                results.add((IAtsWorkItem)rev);
            }
        }
        return results;
    }

    private Set<IAtsWorkItem> filterAttrValues(AtsSearchData data, Set<IAtsWorkItem> workItems) {
        AttributeValues attrValues = data.getAttrValues();
        if (attrValues.isEmpty()) {
            return workItems;
        }
        HashSet<IAtsWorkItem> results = new HashSet<IAtsWorkItem>();
        for (IAtsWorkItem workItem : workItems) {
            for (AttributeValue attrValue : attrValues.getAttributes()) {
                AttributeTypeToken attrType = attrValue.getAttrType();
                List values = attrValue.getValues();
                List workItemAttrValues = this.atsApi.getAttributeResolver().getAttributesToStringList((IAtsObject)workItem, attrType);
                if (values.isEmpty() && workItemAttrValues.isEmpty()) {
                    results.add(workItem);
                    continue;
                }
                if (org.eclipse.osee.framework.jdk.core.util.Collections.setIntersection((Collection)values, (Collection)workItemAttrValues).isEmpty()) continue;
                results.add(workItem);
            }
        }
        return results;
    }

    private Set<IAtsWorkItem> filterUserType(AtsSearchData data, Set<IAtsWorkItem> workItems) {
        AtsSearchUserType userType = data.getUserType();
        String userId = data.getUserId();
        if (Strings.isInvalid((String)userId)) {
            return workItems;
        }
        if (userType.isNone()) {
            return workItems;
        }
        AtsUser user = this.atsApi.getUserService().getUserByUserId(userId);
        if (user == null) {
            return workItems;
        }
        HashSet<IAtsWorkItem> results = new HashSet<IAtsWorkItem>();
        for (IAtsWorkItem workItem : workItems) {
            if (userType.isAssignee() && workItem.getAssignees().contains(user)) {
                results.add(workItem);
                continue;
            }
            if (userType.isOriginated() && workItem.getCreatedBy().equals((Object)user)) {
                results.add(workItem);
                continue;
            }
            if (userType.isFavorites() && this.atsApi.getWorkItemService().isFavorite(workItem, user)) {
                results.add(workItem);
                continue;
            }
            if (!userType.isSubscribed() || !this.atsApi.getWorkItemService().isSubcribed(workItem, user)) continue;
            results.add(workItem);
        }
        return results;
    }

    private Set<IAtsWorkItem> filterChangeType(AtsSearchData data, Set<IAtsWorkItem> workItems) {
        String changeType = data.getChangeType();
        if (Strings.isInValid((String)changeType)) {
            return workItems;
        }
        HashSet<IAtsWorkItem> results = new HashSet<IAtsWorkItem>();
        for (IAtsWorkItem workItem : workItems) {
            if (!changeType.equals(this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.ChangeType, (Object)""))) continue;
            results.add(workItem);
        }
        return results;
    }

    private Set<IAtsWorkItem> filterStateName(AtsSearchData data, Set<IAtsWorkItem> workItems) {
        String stateName = data.getState();
        if (Strings.isInValid((String)stateName)) {
            return workItems;
        }
        HashSet<IAtsWorkItem> results = new HashSet<IAtsWorkItem>();
        for (IAtsWorkItem workItem : workItems) {
            if (!workItem.getCurrentStateName().equals(stateName)) continue;
            results.add(workItem);
        }
        return results;
    }

    private Set<IAtsWorkItem> filterStateType(AtsSearchData data, Set<IAtsWorkItem> workItems) {
        List stateTypes = data.getStateTypes();
        if (stateTypes.isEmpty()) {
            return workItems;
        }
        HashSet<IAtsWorkItem> results = new HashSet<IAtsWorkItem>();
        for (IAtsWorkItem workItem : workItems) {
            if (!stateTypes.contains(workItem.getCurrentStateType())) continue;
            results.add(workItem);
        }
        return results;
    }

    private boolean matchTeamDefs(IAtsTeamWorkflow teamWf) {
        List teamDefIds = this.data.getTeamDefIds();
        if (!teamDefIds.isEmpty()) {
            return teamDefIds.contains(teamWf.getTeamDefinition().getId());
        }
        return false;
    }

    private boolean matchAis(IAtsTeamWorkflow teamWf) {
        List aiIds = this.data.getAiIds();
        if (!aiIds.isEmpty()) {
            for (IAtsActionableItem ai : teamWf.getActionableItems()) {
                if (!aiIds.contains(ai.getId())) continue;
                return true;
            }
        }
        return false;
    }
}

