/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.query.IAtsWorkItemFilter;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.workdef.StateType;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.type.Id;

public class AtsWorkItemFilter
implements IAtsWorkItemFilter {
    private Collection<? extends IAtsWorkItem> items;
    private final AtsApi atsApi;

    public AtsWorkItemFilter(Collection<? extends IAtsWorkItem> workItems) {
        this.items = new ArrayList<IAtsWorkItem>(workItems);
        this.atsApi = AtsApiService.get();
    }

    public IAtsWorkItemFilter isOfType(ArtifactTypeToken ... artifactType) {
        for (IAtsWorkItem iAtsWorkItem : new CopyOnWriteArrayList<IAtsWorkItem>(this.items)) {
            boolean found = false;
            ArtifactTypeToken[] artifactTypeTokenArray = artifactType;
            int n = artifactType.length;
            int n2 = 0;
            while (n2 < n) {
                ArtifactTypeToken matchType = artifactTypeTokenArray[n2];
                if (iAtsWorkItem.getArtifactType().inheritsFrom((ArtifactTypeId)matchType)) {
                    found = true;
                    break;
                }
                ++n2;
            }
            if (found) continue;
            this.items.remove(iAtsWorkItem);
        }
        return this;
    }

    public IAtsWorkItemFilter union(IAtsWorkItemFilter ... workItemFilter) {
        HashSet<? extends IAtsWorkItem> items = new HashSet<IAtsWorkItem>();
        items.addAll(this.items);
        IAtsWorkItemFilter[] iAtsWorkItemFilterArray = workItemFilter;
        int n = workItemFilter.length;
        int n2 = 0;
        while (n2 < n) {
            IAtsWorkItemFilter filter = iAtsWorkItemFilterArray[n2];
            items.addAll(filter.getItems());
            ++n2;
        }
        this.items = items;
        return this;
    }

    public IAtsWorkItemFilter fromTeam(IAtsTeamDefinition teamDef) {
        for (IAtsWorkItem iAtsWorkItem : new CopyOnWriteArrayList<IAtsWorkItem>(this.items)) {
            IAtsTeamDefinition itemTeamDef = iAtsWorkItem.getParentTeamWorkflow().getTeamDefinition();
            if (!itemTeamDef.notEqual((Id)teamDef)) continue;
            this.items.remove(iAtsWorkItem);
        }
        return this;
    }

    public IAtsWorkItemFilter isStateType(StateType ... stateType) {
        ArrayList<StateType> types = new ArrayList<StateType>();
        StateType[] stateTypeArray = stateType;
        int n = stateType.length;
        int n2 = 0;
        while (n2 < n) {
            StateType stateType2 = stateTypeArray[n2];
            types.add(stateType2);
            ++n2;
        }
        for (IAtsWorkItem iAtsWorkItem : new CopyOnWriteArrayList<IAtsWorkItem>(this.items)) {
            StateType currentStateType = iAtsWorkItem.getCurrentStateType();
            if (currentStateType.isCompleted() && !types.contains(StateType.Completed)) {
                this.items.remove(iAtsWorkItem);
                continue;
            }
            if (currentStateType.isCancelled() && !types.contains(StateType.Cancelled)) {
                this.items.remove(iAtsWorkItem);
                continue;
            }
            if (!currentStateType.isWorking() || types.contains(StateType.Working)) continue;
            this.items.remove(iAtsWorkItem);
        }
        return this;
    }

    public <T extends IAtsWorkItem> Collection<T> getItems() {
        HashSet<IAtsWorkItem> workItems = new HashSet<IAtsWorkItem>();
        Iterator<? extends IAtsWorkItem> iterator = this.items.iterator();
        while (iterator.hasNext()) {
            workItems.add(iterator.next());
        }
        return workItems;
    }

    public IAtsWorkItemFilter withOrValue(AttributeTypeToken attributeType, Collection<? extends Object> matchValues) {
        if (matchValues != null && !matchValues.isEmpty()) {
            for (IAtsWorkItem iAtsWorkItem : new CopyOnWriteArrayList<IAtsWorkItem>(this.items)) {
                Collection currAttrValues = this.atsApi.getAttributeResolver().getAttributeValues((IAtsObject)iAtsWorkItem, attributeType);
                boolean found = false;
                for (Object object : matchValues) {
                    if (!currAttrValues.contains(object)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this.items.remove(iAtsWorkItem);
            }
        }
        return this;
    }

    public Collection<IAtsAction> getActions() {
        HashSet<IAtsAction> actions = new HashSet<IAtsAction>();
        for (IAtsWorkItem workItem : this.getItems()) {
            actions.add(workItem.getParentAction());
        }
        return actions;
    }

    public Collection<IAtsTeamWorkflow> getTeamWorkflows() {
        HashSet<IAtsTeamWorkflow> teamWfs = new HashSet<IAtsTeamWorkflow>();
        for (IAtsWorkItem workItem : this.getItems()) {
            teamWfs.add(workItem.getParentTeamWorkflow());
        }
        return teamWfs;
    }
}

