/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.review.hooks;

import java.util.Collection;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.review.DecisionReviewOptions;
import org.eclipse.osee.ats.api.review.DecisionReviewState;
import org.eclipse.osee.ats.api.review.IAtsDecisionReview;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workflow.hooks.IAtsTransitionHook;
import org.eclipse.osee.ats.api.workflow.transition.TransitionResults;

public class AtsDecisionReviewPrepareWorkItemHook
implements IAtsTransitionHook {
    public String getName() {
        return AtsDecisionReviewPrepareWorkItemHook.class.getSimpleName();
    }

    public String getDescription() {
        return "Add validation of Decision Review options prior to transitioning from Prepare to Decision.";
    }

    public void transitioning(TransitionResults results, IAtsWorkItem workItem, IStateToken fromState, IStateToken toState, Collection<AtsUser> toAssignees, AtsUser asUser, AtsApi atsApi) {
        if (workItem.isDecisionReview() && fromState.isState((IStateToken)DecisionReviewState.Prepare) && toState.isState((IStateToken)DecisionReviewState.Decision)) {
            DecisionReviewOptions decOptions = new DecisionReviewOptions((IAtsDecisionReview)workItem, atsApi);
            decOptions.validateDecisionOptions(results);
        }
    }
}

