/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.osee.ats.api.IAtsConfigObject;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.ActionableItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.config.TeamDefinition;
import org.eclipse.osee.ats.api.data.AtsArtifactToken;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.review.DecisionReviewState;
import org.eclipse.osee.ats.api.review.IAtsAbstractReview;
import org.eclipse.osee.ats.api.review.IAtsDecisionReview;
import org.eclipse.osee.ats.api.review.IAtsPeerToPeerReview;
import org.eclipse.osee.ats.api.task.JaxAtsTask;
import org.eclipse.osee.ats.api.task.NewTaskData;
import org.eclipse.osee.ats.api.task.NewTaskSet;
import org.eclipse.osee.ats.api.team.ChangeTypes;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.version.Version;
import org.eclipse.osee.ats.api.workdef.AtsWorkDefinitionTokens;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workdef.StateType;
import org.eclipse.osee.ats.api.workdef.StateTypeAdapter;
import org.eclipse.osee.ats.api.workdef.model.LayoutItem;
import org.eclipse.osee.ats.api.workdef.model.ReviewBlockType;
import org.eclipse.osee.ats.api.workdef.model.StateDefinition;
import org.eclipse.osee.ats.api.workdef.model.WidgetDefinition;
import org.eclipse.osee.ats.api.workflow.ActionResult;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.transition.TransitionData;
import org.eclipse.osee.ats.api.workflow.transition.TransitionOption;
import org.eclipse.osee.ats.api.workflow.transition.TransitionResults;
import org.eclipse.osee.ats.core.internal.AtsApiService;
import org.eclipse.osee.ats.core.workdef.SimpleDecisionReviewOption;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.enums.DemoBranches;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.NamedIdBase;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Lib;

public class AtsTestUtilCore {
    private static IAtsTeamWorkflow teamWf;
    private static IAtsTeamWorkflow teamArt2;
    private static IAtsTeamWorkflow teamArt3;
    private static IAtsTeamWorkflow teamArt4;
    private static TeamDefinition teamDef;
    private static Version verArt1;
    private static Version verArt2;
    private static Version verArt3;
    private static Version verArt4;
    private static IAtsDecisionReview decRevArt;
    private static IAtsPeerToPeerReview peerRev;
    private static IAtsTask taskArtWf1;
    private static IAtsTask taskArtWf2;
    private static ActionableItem testAi;
    private static ActionableItem testAi2;
    private static ActionableItem testAi3;
    private static ActionableItem testAi4;
    private static IAtsAction actionArt;
    private static IAtsAction actionArt2;
    private static IAtsAction actionArt3;
    private static IAtsAction actionArt4;
    private static StateDefinition analyze;
    private static StateDefinition implement;
    private static StateDefinition completed;
    private static StateDefinition cancelled;
    private static WidgetDefinition estHoursWidgetDef;
    private static WidgetDefinition workPackageWidgetDef;
    private static String postFixName;
    private static Boolean productionDatastore;
    private static AtsUser asUser;

    public static void validateObjectsNull() {
        AtsTestUtilCore.validateObjectsNull("teamArt", teamWf);
        AtsTestUtilCore.validateObjectsNull("teamArt2", teamArt2);
        AtsTestUtilCore.validateObjectsNull("teamArt3", teamArt3);
        AtsTestUtilCore.validateObjectsNull("teamArt4", teamArt4);
        AtsTestUtilCore.validateObjectsNull("teamDef", teamDef);
        AtsTestUtilCore.validateObjectsNull("verArt1", verArt1);
        AtsTestUtilCore.validateObjectsNull("verArt2", verArt2);
        AtsTestUtilCore.validateObjectsNull("verArt3", verArt3);
        AtsTestUtilCore.validateObjectsNull("verArt4", verArt4);
        AtsTestUtilCore.validateObjectsNull("decRevArt", decRevArt);
        AtsTestUtilCore.validateObjectsNull("peerRevArt", peerRev);
        AtsTestUtilCore.validateObjectsNull("taskArt1", taskArtWf1);
        AtsTestUtilCore.validateObjectsNull("taskArt2", taskArtWf2);
        AtsTestUtilCore.validateObjectsNull("testAi", testAi);
        AtsTestUtilCore.validateObjectsNull("testAi2", testAi2);
        AtsTestUtilCore.validateObjectsNull("testAi3", testAi3);
        AtsTestUtilCore.validateObjectsNull("testAi4", testAi4);
        AtsTestUtilCore.validateObjectsNull("actionArt", actionArt);
        AtsTestUtilCore.validateObjectsNull("actionArt2", actionArt2);
        AtsTestUtilCore.validateObjectsNull("actionArt3", actionArt3);
        AtsTestUtilCore.validateObjectsNull("actionArt4", actionArt4);
        AtsTestUtilCore.validateObjectsNull("analyze", analyze);
        AtsTestUtilCore.validateObjectsNull("implement", implement);
        AtsTestUtilCore.validateObjectsNull("completed", completed);
        AtsTestUtilCore.validateObjectsNull("cancelled", cancelled);
        AtsTestUtilCore.validateObjectsNull("estHoursWidgetDef", estHoursWidgetDef);
        AtsTestUtilCore.validateObjectsNull("workPackageWidgetDef", workPackageWidgetDef);
    }

    private static void validateObjectsNull(String name, Object obj) {
        if (obj != null) {
            throw new OseeStateException("[%s] objects should be null but is not", new Object[]{name});
        }
    }

    public static StateDefinition getAnalyzeStateDef() {
        AtsTestUtilCore.ensureLoaded();
        if (analyze == null) {
            analyze = teamWf.getWorkDefinition().getStateByName("Analyze");
        }
        return analyze;
    }

    public static WidgetDefinition getEstHoursWidgetDef() {
        AtsTestUtilCore.ensureLoaded();
        if (estHoursWidgetDef == null) {
            for (LayoutItem item : AtsTestUtilCore.getAnalyzeStateDef().getLayoutItems()) {
                if (!item.getName().equals("ats.Estimated Hours")) continue;
                estHoursWidgetDef = (WidgetDefinition)item;
                break;
            }
        }
        return estHoursWidgetDef;
    }

    public static WidgetDefinition getWorkPackageWidgetDef() {
        AtsTestUtilCore.ensureLoaded();
        if (workPackageWidgetDef == null) {
            for (LayoutItem item : AtsTestUtilCore.getAnalyzeStateDef().getLayoutItems()) {
                if (!item.getName().equals("ats.Work Package")) continue;
                workPackageWidgetDef = (WidgetDefinition)item;
                break;
            }
        }
        return workPackageWidgetDef;
    }

    public static StateDefinition getImplementStateDef() {
        AtsTestUtilCore.ensureLoaded();
        if (implement == null) {
            implement = teamWf.getWorkDefinition().getStateByName("Implement");
        }
        return implement;
    }

    public static StateDefinition getCompletedStateDef() {
        AtsTestUtilCore.ensureLoaded();
        if (completed == null) {
            completed = teamWf.getWorkDefinition().getStateByName("Completed");
        }
        return completed;
    }

    public static StateDefinition getCancelledStateDef() {
        AtsTestUtilCore.ensureLoaded();
        if (cancelled == null) {
            cancelled = teamWf.getWorkDefinition().getStateByName("Cancelled");
        }
        return cancelled;
    }

    public static void ensureLoaded() {
        if (teamDef == null) {
            throw new OseeStateException("Must call cleanAndReset before using this method", new Object[0]);
        }
    }

    public static void clearCaches() {
        analyze = null;
        implement = null;
        completed = null;
        cancelled = null;
        estHoursWidgetDef = null;
        workPackageWidgetDef = null;
        teamWf = null;
        teamArt2 = null;
        teamArt3 = null;
        teamArt4 = null;
        teamDef = null;
        taskArtWf1 = null;
        taskArtWf2 = null;
        testAi = null;
        testAi2 = null;
        testAi3 = null;
        testAi4 = null;
        actionArt = null;
        actionArt2 = null;
        actionArt3 = null;
        actionArt4 = null;
        verArt1 = null;
        verArt2 = null;
        verArt3 = null;
        verArt4 = null;
        decRevArt = null;
        peerRev = null;
    }

    public static String getTitle(String objectName, String postFixName) {
        return String.format("%s - %s [%s]", AtsTestUtilCore.class.getSimpleName(), objectName, postFixName);
    }

    public static void reset(String postFixName, boolean clearCaches) {
        if (AtsTestUtilCore.isProductionDataStore()) {
            throw new OseeStateException("AtsTestUtil should not be run on production.", new Object[0]);
        }
        AtsTestUtilCore.postFixName = postFixName;
        IAtsChangeSet changes = AtsApiService.get().createChangeSet(AtsTestUtilCore.class.getSimpleName(), AtsTestUtilCore.getUser());
        ActionableItem topAi = AtsApiService.get().getActionableItemService().getActionableItemById((ArtifactId)AtsArtifactToken.TopActionableItem);
        testAi = AtsApiService.get().getActionableItemService().createActionableItem(AtsTestUtilCore.getTitle("AI", postFixName), Lib.generateArtifactIdAsInt().longValue(), changes);
        changes.setSoleAttributeValue((IAtsObject)testAi, (AttributeTypeToken)AtsAttributeTypes.Active, (Object)true);
        changes.setSoleAttributeValue((IAtsObject)testAi, (AttributeTypeToken)AtsAttributeTypes.Actionable, (Object)true);
        testAi.setActive(true);
        testAi.setActionable(true);
        changes.addChild((IAtsObject)topAi, (IAtsObject)testAi);
        testAi2 = AtsApiService.get().getActionableItemService().createActionableItem(AtsTestUtilCore.getTitle("AI2", postFixName), Lib.generateArtifactIdAsInt().longValue(), changes);
        changes.setSoleAttributeValue((IAtsObject)testAi2, (AttributeTypeToken)AtsAttributeTypes.Active, (Object)true);
        changes.setSoleAttributeValue((IAtsObject)testAi2, (AttributeTypeToken)AtsAttributeTypes.Actionable, (Object)true);
        testAi2.setActive(true);
        testAi2.setActionable(true);
        changes.addChild((IAtsObject)testAi, (IAtsObject)testAi2);
        testAi3 = AtsApiService.get().getActionableItemService().createActionableItem(AtsTestUtilCore.getTitle("AI3", postFixName), Lib.generateArtifactIdAsInt().longValue(), changes);
        changes.setSoleAttributeValue((IAtsObject)testAi3, (AttributeTypeToken)AtsAttributeTypes.Active, (Object)true);
        changes.setSoleAttributeValue((IAtsObject)testAi3, (AttributeTypeToken)AtsAttributeTypes.Actionable, (Object)true);
        testAi3.setActive(true);
        testAi3.setActionable(true);
        changes.addChild((IAtsObject)testAi, (IAtsObject)testAi3);
        testAi4 = AtsApiService.get().getActionableItemService().createActionableItem(AtsTestUtilCore.getTitle("AI4", postFixName), Lib.generateArtifactIdAsInt().longValue(), changes);
        changes.setSoleAttributeValue((IAtsObject)testAi4, (AttributeTypeToken)AtsAttributeTypes.Active, (Object)true);
        changes.setSoleAttributeValue((IAtsObject)testAi4, (AttributeTypeToken)AtsAttributeTypes.Actionable, (Object)true);
        testAi4.setActive(true);
        testAi4.setActionable(true);
        changes.addChild((IAtsObject)testAi, (IAtsObject)testAi4);
        teamDef = AtsApiService.get().getTeamDefinitionService().createTeamDefinition(AtsTestUtilCore.getTitle("Team Def", postFixName), Lib.generateArtifactIdAsInt().longValue(), changes);
        AtsApiService.get().getConfigService().getConfigurations().getIdToTeamDef().put(teamDef.getId(), teamDef);
        AtsApiService.get().getWorkDefinitionService().setWorkDefinitionAttrs((IAtsTeamDefinition)teamDef, (NamedIdBase)AtsWorkDefinitionTokens.WorkDef_Team_Simple_Analyze, changes);
        changes.setSoleAttributeValue((IAtsObject)teamDef, (AttributeTypeToken)AtsAttributeTypes.Active, (Object)true);
        changes.relate((Object)teamDef, AtsRelationTypes.TeamLead_Lead, (Object)AtsTestUtilCore.getUser());
        changes.relate((Object)teamDef, AtsRelationTypes.TeamActionableItem_ActionableItem, (Object)testAi);
        changes.relate((Object)teamDef, AtsRelationTypes.TeamActionableItem_ActionableItem, (Object)testAi2);
        changes.relate((Object)teamDef, AtsRelationTypes.TeamActionableItem_ActionableItem, (Object)testAi3);
        changes.relate((Object)teamDef, AtsRelationTypes.TeamActionableItem_ActionableItem, (Object)testAi4);
        testAi.setTeamDefId(teamDef.getId());
        testAi2.setTeamDefId(teamDef.getId());
        testAi3.setTeamDefId(teamDef.getId());
        testAi4.setTeamDefId(teamDef.getId());
        TeamDefinition topTeamDef = AtsApiService.get().getTeamDefinitionService().getTeamDefinitionById((ArtifactId)AtsArtifactToken.TopTeamDefinition);
        changes.addChild((IAtsObject)topTeamDef, (IAtsObject)teamDef);
        verArt1 = AtsApiService.get().getVersionService().createVersion(AtsTestUtilCore.getTitle("ver 1.0", postFixName), Lib.generateArtifactIdAsInt().longValue(), changes);
        changes.relate((Object)teamDef, AtsRelationTypes.TeamDefinitionToVersion_Version, (Object)verArt1);
        verArt1.setTeamDefId(teamDef.getId());
        teamDef.getVersions().add(verArt1.getId());
        verArt2 = AtsApiService.get().getVersionService().createVersion(AtsTestUtilCore.getTitle("ver 2.0", postFixName), Lib.generateArtifactIdAsInt().longValue(), changes);
        changes.relate((Object)teamDef, AtsRelationTypes.TeamDefinitionToVersion_Version, (Object)verArt2);
        verArt2.setTeamDefId(teamDef.getId());
        teamDef.getVersions().add(verArt2.getId());
        verArt3 = AtsApiService.get().getVersionService().createVersion(AtsTestUtilCore.getTitle("ver 3.0", postFixName), Lib.generateArtifactIdAsInt().longValue(), changes);
        changes.relate((Object)teamDef, AtsRelationTypes.TeamDefinitionToVersion_Version, (Object)verArt3);
        verArt3.setTeamDefId(teamDef.getId());
        teamDef.getVersions().add(verArt3.getId());
        verArt4 = AtsApiService.get().getVersionService().createVersion(AtsTestUtilCore.getTitle("ver 4.0", postFixName), Lib.generateArtifactIdAsInt().longValue(), changes);
        changes.relate((Object)teamDef, AtsRelationTypes.TeamDefinitionToVersion_Version, (Object)verArt4);
        verArt4.setTeamDefId(teamDef.getId());
        teamDef.getVersions().add(verArt4.getId());
        ActionResult result = AtsApiService.get().getActionService().createAction(null, AtsTestUtilCore.getTitle("Team WF", postFixName), "description", ChangeTypes.Improvement, "1", false, null, Arrays.asList(testAi), new Date(), AtsTestUtilCore.getUser(), null, changes);
        if (result.getResults().isErrors()) {
            throw new OseeStateException("Error creating action %s", new Object[]{result.getResults().toString()});
        }
        actionArt = AtsApiService.get().getWorkItemService().getAction(result.getAction().getStoreObject());
        teamWf = AtsApiService.get().getWorkItemService().getTeamWf(result.getFirstTeam().getStoreObject());
        changes.execute();
        if (clearCaches) {
            AtsApiService.get().reloadServerAndClientCaches();
        }
    }

    private static AtsUser getUser() {
        if (asUser == null) {
            return AtsApiService.get().getUserService().getCurrentUser();
        }
        return asUser;
    }

    public static boolean isProductionDataStore() {
        if (productionDatastore == null) {
            productionDatastore = AtsApiService.get().getStoreService().isProductionDb();
        }
        return productionDatastore;
    }

    public static IAtsTask getOrCreateTaskOffTeamWf1() {
        AtsTestUtilCore.ensureLoaded();
        if (taskArtWf1 == null) {
            NewTaskData newTaskData = NewTaskData.create((IAtsTeamWorkflow)teamWf, Arrays.asList(AtsTestUtilCore.getTitle("Task", postFixName)), null, (Date)new Date(), (AtsUser)AtsTestUtilCore.getUser(), (String)teamWf.getCurrentStateName(), null, null);
            NewTaskSet newTaskSet = NewTaskSet.create((NewTaskData)newTaskData, (String)(String.valueOf(AtsTestUtilCore.getName()) + " Create Task"), (String)AtsTestUtilCore.getUser().getUserId());
            newTaskSet = AtsApiService.get().getTaskService().createTasks(newTaskSet);
            taskArtWf1 = (IAtsTask)((JaxAtsTask)newTaskSet.getTaskData().getTasks().iterator().next()).getStoreObject();
        }
        return taskArtWf1;
    }

    public static IAtsDecisionReview getOrCreateDecisionReview(ReviewBlockType reviewBlockType, AtsTestUtilState relatedToState, IAtsChangeSet changes) {
        AtsTestUtilCore.ensureLoaded();
        if (decRevArt == null) {
            ArrayList<SimpleDecisionReviewOption> options = new ArrayList<SimpleDecisionReviewOption>();
            options.add(new SimpleDecisionReviewOption(DecisionReviewState.Completed.getName(), false, null));
            options.add(new SimpleDecisionReviewOption(DecisionReviewState.Followup.getName(), true, Arrays.asList(AtsTestUtilCore.getUser().getUserId())));
            decRevArt = (IAtsDecisionReview)AtsApiService.get().getReviewService().createNewDecisionReview(teamWf, reviewBlockType, String.valueOf(AtsTestUtilCore.class.getSimpleName()) + " Test Decision Review", relatedToState.getName(), "Decision Review", options, Arrays.asList(AtsTestUtilCore.getUser()), new Date(), AtsTestUtilCore.getUser(), changes).getStoreObject();
        }
        return decRevArt;
    }

    public static IAtsTeamWorkflow getTeamWf() {
        AtsTestUtilCore.ensureLoaded();
        return teamWf;
    }

    public static IAtsActionableItem getTestAi() {
        AtsTestUtilCore.ensureLoaded();
        return testAi;
    }

    public static IAtsTeamDefinition getTestTeamDef() {
        AtsTestUtilCore.ensureLoaded();
        return teamDef;
    }

    public static void cleanupAndReset(String name) {
        AtsTestUtilCore.cleanupAndReset(name, false);
    }

    public static void cleanupAndReset(String name, boolean clearCaches) {
        AtsTestUtilCore.cleanup();
        AtsTestUtilCore.reset(name, clearCaches);
    }

    public static void cleanupAndReset(String name, boolean clearCaches, AtsUser asUser) {
        AtsTestUtilCore.asUser = asUser;
        AtsTestUtilCore.cleanup();
        AtsTestUtilCore.reset(name, clearCaches);
    }

    public static void delete(IAtsChangeSet changes, Object artifact) {
        if (artifact != null) {
            changes.addToDelete(artifact);
        }
    }

    public static void deleteTeamWf(IAtsTeamWorkflow teamWfToDelete) {
        if (teamWfToDelete != null) {
            XResultData result;
            IAtsChangeSet changes = AtsApiService.get().createChangeSet(String.valueOf(AtsTestUtilCore.class.getSimpleName()) + " - cleanup deleteTeamWf", AtsTestUtilCore.getUser());
            BranchToken workingBranch = AtsApiService.get().getBranchService().getWorkingBranch(teamWfToDelete);
            if (workingBranch.isValid() && (result = AtsApiService.get().getBranchService().deleteBranch((BranchId)workingBranch)).isErrors()) {
                throw new OseeStateException("Error deleting working branch [%s]", new Object[]{result.toString()});
            }
            for (IAtsTask task : AtsApiService.get().getTaskService().getTasks(teamWfToDelete)) {
                changes.addToDelete((Object)task);
            }
            for (IAtsAbstractReview revArt : AtsApiService.get().getReviewService().getReviews(teamWfToDelete)) {
                changes.addToDelete((Object)revArt);
            }
            changes.addToDelete((Object)teamWfToDelete);
            if (!changes.isEmpty()) {
                changes.execute();
            }
        }
    }

    public static void cleanup() {
        BranchToken branchToken;
        BranchToken workingBranch;
        if (teamWf != null && (workingBranch = AtsApiService.get().getBranchService().getWorkingBranch(teamWf)).isValid()) {
            AtsApiService.get().getBranchService().deleteBranch((BranchId)workingBranch);
        }
        IAtsChangeSet changes = AtsApiService.get().createChangeSet(String.valueOf(AtsTestUtilCore.class.getSimpleName()) + " - cleanup 1", AtsTestUtilCore.getUser());
        AtsTestUtilCore.delete(changes, peerRev);
        AtsTestUtilCore.delete(changes, decRevArt);
        AtsTestUtilCore.delete(changes, taskArtWf1);
        AtsTestUtilCore.delete(changes, taskArtWf2);
        AtsTestUtilCore.delete(changes, actionArt);
        AtsTestUtilCore.delete(changes, actionArt2);
        AtsTestUtilCore.delete(changes, actionArt3);
        AtsTestUtilCore.delete(changes, actionArt4);
        if (verArt1 != null) {
            AtsTestUtilCore.delete(changes, verArt1);
        }
        if (verArt2 != null) {
            AtsTestUtilCore.delete(changes, verArt2);
        }
        if (verArt3 != null) {
            AtsTestUtilCore.delete(changes, verArt3);
        }
        if (verArt4 != null) {
            AtsTestUtilCore.delete(changes, verArt4);
        }
        if (!changes.isEmpty()) {
            changes.execute();
        }
        if (teamWf != null && (branchToken = AtsApiService.get().getBranchService().getBranch(teamWf)).isValid()) {
            AtsApiService.get().getBranchService().setAssociatedArtId((BranchId)branchToken, ArtifactId.SENTINEL);
            XResultData rd = AtsApiService.get().getBranchService().deleteBranch((BranchId)branchToken);
            if (rd.isErrors()) {
                throw new OseeCoreException(rd.toString(), new Object[0]);
            }
        }
        AtsTestUtilCore.deleteTeamWf(teamWf);
        AtsTestUtilCore.deleteTeamWf(teamArt2);
        AtsTestUtilCore.deleteTeamWf(teamArt3);
        AtsTestUtilCore.deleteTeamWf(teamArt4);
        changes = AtsApiService.get().createChangeSet(String.valueOf(AtsTestUtilCore.class.getSimpleName()) + " - cleanup config", AtsTestUtilCore.getUser());
        for (IAtsConfigObject iAtsConfigObject : Arrays.asList(teamDef, testAi, testAi2, testAi3, testAi4)) {
            if (iAtsConfigObject == null || AtsApiService.get().getStoreService().isDeleted((IAtsObject)iAtsConfigObject)) continue;
            changes.deleteArtifact((ArtifactId)iAtsConfigObject.getStoreObject());
        }
        changes.executeIfNeeded();
        AtsTestUtilCore.clearCaches();
    }

    public static IAtsVersion getVerArt1() {
        return verArt1;
    }

    public static IAtsVersion getVerArt2() {
        return verArt2;
    }

    public static IAtsVersion getVerArt3() {
        return verArt3;
    }

    public static IAtsVersion getVerArt4() {
        return verArt4;
    }

    public static void cleanupSimpleTest(String title) {
        AtsTestUtilCore.cleanupSimpleTest(Arrays.asList(title));
    }

    public static void cleanupSimpleTest(Collection<String> titles) {
        ArrayList artifacts = new ArrayList();
        for (String title : titles) {
            artifacts.addAll(AtsApiService.get().getQueryService().getArtifactsFromName(title, AtsApiService.get().getAtsBranch(), DeletionFlag.EXCLUDE_DELETED, QueryOption.CONTAINS_MATCH_OPTIONS));
        }
        if (AtsApiService.get().isIde()) {
            AtsApiService.get().getStoreService().purgeArtifacts(artifacts);
        } else {
            AtsApiService.get().getStoreService().deleteArtifacts(artifacts);
        }
    }

    public static Result transitionTo(AtsTestUtilState atsTestUtilState, AtsUser user, TransitionOption ... transitionOptions) {
        return AtsTestUtilCore.transitionTo(teamWf, atsTestUtilState, user, transitionOptions);
    }

    public static Result transitionTo(IAtsTeamWorkflow teamWf, AtsTestUtilState atsTestUtilState, AtsUser user, TransitionOption ... transitionOptions) {
        if (atsTestUtilState == AtsTestUtilState.Analyze && teamWf.isInState(new IStateToken[]{AtsTestUtilState.Analyze})) {
            return Result.TrueResult;
        }
        if (atsTestUtilState == AtsTestUtilState.Cancelled) {
            Result result = AtsTestUtilCore.transitionToState(teamWf, (IStateToken)AtsTestUtilState.Cancelled, user, transitionOptions);
            if (result.isFalse()) {
                return result;
            }
            return Result.TrueResult;
        }
        Result result = AtsTestUtilCore.transitionToState(teamWf, (IStateToken)AtsTestUtilState.Implement, user, transitionOptions);
        if (result.isFalse()) {
            return result;
        }
        if (atsTestUtilState == AtsTestUtilState.Implement) {
            return Result.TrueResult;
        }
        if (atsTestUtilState == AtsTestUtilState.Completed && (result = AtsTestUtilCore.transitionToState(teamWf, (IStateToken)AtsTestUtilState.Completed, user, transitionOptions)).isFalse()) {
            return result;
        }
        return Result.TrueResult;
    }

    public static Result transitionToState(IAtsTeamWorkflow teamWf, IStateToken toState, AtsUser user, TransitionOption ... transitionOptions) {
        TransitionData transData = new TransitionData("Transition to " + toState.getName(), Arrays.asList(teamWf), toState.getName(), Arrays.asList(user), null, null, transitionOptions);
        TransitionResults results = AtsApiService.get().getWorkItemService().transition(transData);
        if (results.isEmpty()) {
            return Result.TrueResult;
        }
        return new Result("Transition Error %s", new Object[]{results.toString()});
    }

    public static IAtsPeerToPeerReview getOrCreatePeerReview(ReviewBlockType reviewBlockType, AtsTestUtilState relatedToState, IAtsChangeSet changes) {
        AtsTestUtilCore.ensureLoaded();
        try {
            if (peerRev == null) {
                peerRev = AtsApiService.get().getReviewService().createNewPeerToPeerReview(AtsApiService.get().getWorkDefinitionService().getDefaultPeerToPeerWorkflowDefinition(), teamWf, String.valueOf(AtsTestUtilCore.class.getSimpleName()) + " Test Peer Review", relatedToState.getName(), changes);
                changes.setSoleAttributeValue((IAtsWorkItem)peerRev, (AttributeTypeToken)AtsAttributeTypes.ReviewBlocks, reviewBlockType.name());
            }
        }
        catch (OseeCoreException ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
        return peerRev;
    }

    public static IAtsTeamWorkflow getTeamWf2() {
        AtsTestUtilCore.ensureLoaded();
        if (teamArt2 == null) {
            IAtsChangeSet changes = AtsApiService.get().createChangeSet(AtsTestUtilCore.class.getSimpleName());
            ActionResult result = AtsApiService.get().getActionService().createAction(null, AtsTestUtilCore.getTitle("Team WF2", postFixName), "description", ChangeTypes.Improvement, "1", false, null, Arrays.asList(testAi2), new Date(), AtsTestUtilCore.getUser(), null, changes);
            actionArt2 = (IAtsAction)result.getAction().getStoreObject();
            teamArt2 = (IAtsTeamWorkflow)result.getFirstTeam().getStoreObject();
            changes.execute();
        }
        return teamArt2;
    }

    public static IAtsActionableItem getTestAi2() {
        AtsTestUtilCore.ensureLoaded();
        return testAi2;
    }

    public static IAtsTeamWorkflow getTeamWf3() {
        AtsTestUtilCore.ensureLoaded();
        if (teamArt3 == null) {
            IAtsChangeSet changes = AtsApiService.get().createChangeSet(AtsTestUtilCore.class.getSimpleName());
            ActionResult result = AtsApiService.get().getActionService().createAction(null, AtsTestUtilCore.getTitle("Team WF3", postFixName), "description", ChangeTypes.Improvement, "1", false, null, Arrays.asList(testAi3), new Date(), AtsTestUtilCore.getUser(), null, changes);
            actionArt3 = (IAtsAction)result.getAction().getStoreObject();
            teamArt3 = (IAtsTeamWorkflow)result.getFirstTeam().getStoreObject();
            changes.execute();
        }
        return teamArt3;
    }

    public static IAtsActionableItem getTestAi3() {
        AtsTestUtilCore.ensureLoaded();
        return testAi3;
    }

    public static IAtsTeamWorkflow getTeamWf4() {
        AtsTestUtilCore.ensureLoaded();
        if (teamArt4 == null) {
            IAtsChangeSet changes = AtsApiService.get().createChangeSet(AtsTestUtilCore.class.getSimpleName());
            ActionResult result = AtsApiService.get().getActionService().createAction(null, AtsTestUtilCore.getTitle("Team WF4", postFixName), "description", ChangeTypes.Improvement, "1", false, null, Arrays.asList(testAi4), new Date(), AtsTestUtilCore.getUser(), null, changes);
            actionArt4 = (IAtsAction)result.getAction().getStoreObject();
            teamArt4 = (IAtsTeamWorkflow)result.getFirstTeam().getStoreObject();
            AtsApiService.get().getVersionService().setTargetedVersion(teamArt4, (IAtsVersion)verArt4, changes);
            changes.execute();
        }
        return teamArt4;
    }

    public static IAtsActionableItem getTestAi4() {
        AtsTestUtilCore.ensureLoaded();
        return testAi4;
    }

    public static IAtsAction getActionArt2() {
        AtsTestUtilCore.ensureLoaded();
        if (actionArt2 == null) {
            AtsTestUtilCore.getTeamWf2();
        }
        return actionArt2;
    }

    public static IAtsAction getActionArt3() {
        AtsTestUtilCore.ensureLoaded();
        if (actionArt3 == null) {
            AtsTestUtilCore.getTeamWf3();
        }
        return actionArt3;
    }

    public static IAtsAction getActionArt4() {
        AtsTestUtilCore.ensureLoaded();
        if (actionArt4 == null) {
            AtsTestUtilCore.getTeamWf4();
        }
        return actionArt4;
    }

    public static IAtsAction getActionArt() {
        AtsTestUtilCore.ensureLoaded();
        return actionArt;
    }

    public static void configureVer1ForWorkingBranch() {
        IAtsVersion version = AtsTestUtilCore.getVerArt1();
        IAtsChangeSet changes = AtsApiService.get().createChangeSet("configureVer1ForWorkingBranch");
        changes.setSoleAttributeValue((IAtsObject)version, (AttributeTypeToken)AtsAttributeTypes.AllowCreateBranch, (Object)true);
        changes.setSoleAttributeValue((IAtsObject)version, (AttributeTypeToken)AtsAttributeTypes.AllowCommitBranch, (Object)true);
        changes.setSoleAttributeValue((IAtsObject)version, (AttributeTypeToken)AtsAttributeTypes.BaselineBranchId, (Object)DemoBranches.SAW_Bld_1.getIdString());
        changes.setRelations((Object)version, AtsRelationTypes.TeamWorkflowTargetedForVersion_TeamWorkflow, Arrays.asList(teamWf));
        changes.execute();
    }

    public static String getName() {
        return postFixName;
    }

    public static boolean hasTeamWf() {
        return teamWf != null;
    }

    public static void clearVersions() {
        verArt1 = null;
        verArt2 = null;
        verArt3 = null;
        verArt4 = null;
    }

    public static class AtsTestUtilState
    extends StateTypeAdapter {
        public static AtsTestUtilState Analyze = new AtsTestUtilState("Analyze", StateType.Working);
        public static AtsTestUtilState Implement = new AtsTestUtilState("Implement", StateType.Working);
        public static AtsTestUtilState Completed = new AtsTestUtilState("Completed", StateType.Completed);
        public static AtsTestUtilState Cancelled = new AtsTestUtilState("Cancelled", StateType.Cancelled);

        public AtsTestUtilState(String pageName, StateType StateType2) {
            super(AtsTestUtilState.class, pageName, StateType2);
        }

        public static AtsTestUtilState valueOf(String pageName) {
            return (AtsTestUtilState)((Object)StateTypeAdapter.valueOfPage(AtsTestUtilState.class, (String)pageName));
        }

        public static List<AtsTestUtilState> values() {
            return StateTypeAdapter.pages(AtsTestUtilState.class);
        }
    }
}

