/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.util;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.workdef.IRelationResolver;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.util.Collections;

public abstract class AbstractRelationResolverServiceImpl
implements IRelationResolver {
    public Collection<ArtifactToken> getChildren(ArtifactId artifact, ArtifactTypeToken artifactType) {
        return this.getRelated(artifact, CoreRelationTypes.DefaultHierarchical_Child, artifactType);
    }

    public Collection<ArtifactToken> getRelated(IAtsObject atsObject, RelationTypeSide relationTypeSide) {
        return this.getRelated((ArtifactId)atsObject.getStoreObject(), relationTypeSide);
    }

    public abstract ArtifactId getArtifact(Object var1);

    public Collection<ArtifactToken> getRelatedArtifacts(IAtsWorkItem workItem, RelationTypeSide relationTypeSide) {
        ArtifactId artifact = this.getArtifact(workItem);
        return Collections.castAll((Collection)this.getRelated(artifact, relationTypeSide));
    }

    public Collection<ArtifactToken> getChildren(ArtifactId artifact) {
        return this.getRelated(artifact, CoreRelationTypes.DefaultHierarchical_Child);
    }

    public ArtifactToken getParent(ArtifactId artifact) {
        return this.getRelatedOrNull(artifact, CoreRelationTypes.DefaultHierarchical_Parent);
    }

    public Collection<ArtifactToken> getAncestors(ArtifactToken artifact) {
        ArrayList<ArtifactToken> ancestors = new ArrayList<ArtifactToken>();
        ArtifactToken parent = this.getParent((ArtifactId)artifact);
        while (parent != null) {
            ancestors.add(parent);
            parent = this.getParent((ArtifactId)parent);
        }
        return ancestors;
    }

    public boolean areNotRelated(ArtifactId artifact1, RelationTypeSide relationType, ArtifactId artifact2) {
        return !this.areRelated(artifact1, relationType, artifact2);
    }

    public boolean areNotRelated(IAtsObject atsObject1, RelationTypeSide relationType, IAtsObject atsObject2) {
        return !this.areRelated(atsObject1, relationType, atsObject2);
    }

    public Collection<ArtifactToken> getRelated(IAtsObject atsObject, RelationTypeSide relationType, ArtifactTypeToken artifactType) {
        return this.getRelated((ArtifactId)atsObject.getStoreObject(), relationType, artifactType);
    }
}

