/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.util;

import java.util.Collection;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.ev.IAtsEarnedValueService;
import org.eclipse.osee.ats.api.review.IAtsAbstractReview;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.logger.Log;

public abstract class AtsAbstractEarnedValueImpl
implements IAtsEarnedValueService {
    protected final Log logger;
    protected final AtsApi atsApi;

    public AtsAbstractEarnedValueImpl(Log logger, AtsApi atsApi) {
        this.logger = logger;
        this.atsApi = atsApi;
    }

    public double getEstimatedHoursFromArtifact(IAtsWorkItem workItem) {
        return (Double)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.EstimatedHours, (Object)0.0);
    }

    public double getEstimatedHoursFromTasks(IAtsWorkItem workItem) {
        if (!(workItem instanceof IAtsTeamWorkflow)) {
            return 0.0;
        }
        double hours = 0.0;
        for (IAtsTask task : this.atsApi.getTaskService().getTask(workItem)) {
            hours += this.getEstimatedHoursFromArtifact((IAtsWorkItem)task);
        }
        return hours;
    }

    public double getEstimatedHoursFromReviews(IAtsWorkItem workItem) {
        double hours = 0.0;
        if (workItem.isTeamWorkflow()) {
            for (IAtsAbstractReview review : this.atsApi.getReviewService().getReviews((IAtsTeamWorkflow)workItem)) {
                hours += this.getEstimatedHoursFromArtifact((IAtsWorkItem)review);
            }
        }
        return hours;
    }

    public double getEstimatedHoursFromReviews(IAtsWorkItem workItem, IStateToken relatedToState) {
        double hours = 0.0;
        if (workItem.isTeamWorkflow()) {
            IAtsTeamWorkflow teamWf = (IAtsTeamWorkflow)workItem;
            for (IAtsAbstractReview review : this.atsApi.getReviewService().getReviews(teamWf)) {
                if (!review.getRelatedToState().equals(relatedToState.getName())) continue;
                hours += this.getEstimatedHoursFromArtifact((IAtsWorkItem)review);
            }
        }
        return hours;
    }

    public double getEstimatedHoursTotal(IAtsWorkItem workItem) {
        return this.getEstimatedHoursFromArtifact(workItem) + this.getEstimatedHoursFromTasks(workItem) + this.getEstimatedHoursFromReviews(workItem);
    }

    public double getRemainHoursFromArtifact(IAtsWorkItem workItem) {
        if (workItem.isCompletedOrCancelled()) {
            return 0.0;
        }
        double est = (Double)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.EstimatedHours, (Object)0.0);
        if (est == 0.0) {
            return this.getEstimatedHoursFromArtifact(workItem);
        }
        return est - est * (double)this.atsApi.getWorkItemMetricsService().getPercentCompleteTotal((IAtsObject)workItem) / 100.0;
    }

    public double getRemainHoursTotal(IAtsWorkItem workItem) {
        return this.getRemainHoursFromArtifact(workItem) + this.getRemainFromTasks(workItem) + this.getRemainFromReviews(workItem);
    }

    public double getRemainFromTasks(IAtsWorkItem workItem) {
        if (!workItem.isTeamWorkflow()) {
            return 0.0;
        }
        double hours = 0.0;
        for (IAtsTask task : this.atsApi.getTaskService().getTasks((IAtsTeamWorkflow)workItem)) {
            hours += this.getRemainHoursFromArtifact((IAtsWorkItem)task);
        }
        return hours;
    }

    public double getRemainFromReviews(IAtsWorkItem workItem) {
        if (workItem.isTeamWorkflow()) {
            return this.atsApi.getEarnedValueService().getEstimatedHoursFromReviews(workItem);
        }
        return 0.0;
    }

    public double getManHrsPerDayPreference() {
        return 8.0;
    }

    public int getPercentCompleteFromTasks(IAtsWorkItem workItem, IStateToken relatedToState) {
        int spent = 0;
        int result = 0;
        if (workItem.isTeamWorkflow()) {
            Collection tasks = this.atsApi.getTaskService().getTasks((IAtsTeamWorkflow)workItem, relatedToState);
            for (IAtsTask task : tasks) {
                spent += this.atsApi.getWorkItemMetricsService().getPercentCompleteTotal((IAtsObject)task);
            }
            if (spent > 0) {
                result = spent / tasks.size();
            }
        }
        return result;
    }

    public int getPercentCompleteFromTasks(IAtsWorkItem workItem) {
        int spent = 0;
        int result = 0;
        if (workItem.isTeamWorkflow()) {
            Collection tasks = this.atsApi.getTaskService().getTasks((IAtsTeamWorkflow)workItem);
            for (IAtsTask task : tasks) {
                spent += this.atsApi.getWorkItemMetricsService().getPercentCompleteTotal((IAtsObject)task);
            }
            if (spent > 0) {
                result = spent / tasks.size();
            }
        }
        return result;
    }

    public int getPercentCompleteFromReviews(IAtsWorkItem workItem, IStateToken relatedToState) {
        int spent = 0;
        if (workItem.isTeamWorkflow()) {
            Collection reviews = this.atsApi.getReviewService().getReviews((IAtsTeamWorkflow)workItem, relatedToState);
            for (IAtsAbstractReview review : reviews) {
                spent += this.atsApi.getWorkItemMetricsService().getPercentCompleteTotal((IAtsObject)review);
            }
            if (spent == 0) {
                return 0;
            }
            spent /= reviews.size();
        }
        return spent;
    }
}

