/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.validator;

import java.util.Arrays;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.util.IValueProvider;
import org.eclipse.osee.ats.api.workdef.WidgetResult;
import org.eclipse.osee.ats.api.workdef.WidgetStatus;
import org.eclipse.osee.ats.api.workdef.model.StateDefinition;
import org.eclipse.osee.ats.api.workdef.model.WidgetDefinition;
import org.eclipse.osee.ats.core.validator.AtsXWidgetValidator;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;

public class AtsXPointsAttrValidator
extends AtsXWidgetValidator {
    @Override
    public WidgetResult validateTransition(IAtsWorkItem workItem, IValueProvider provider, WidgetDefinition widgetDef, StateDefinition fromStateDef, StateDefinition toStateDef, AtsApi atsApi) {
        WidgetResult result = WidgetResult.Success;
        if ("XEstimatedPointsWidget".equals(widgetDef.getXWidgetName())) {
            boolean found = false;
            for (AttributeTypeToken attributeTypeToken : Arrays.asList(AtsAttributeTypes.Points, AtsAttributeTypes.PointsNumeric)) {
                if (atsApi.getAttributeResolver().getAttributeCount(workItem, attributeTypeToken) <= 0) continue;
                found = true;
                break;
            }
            if (!found) {
                result = new WidgetResult(WidgetStatus.Invalid_Incompleted, "[%s] is required for transition to [%s]", new Object[]{widgetDef.getName(), toStateDef.getName()});
            }
        }
        return result;
    }
}

