/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer.action;

import java.util.logging.Level;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.nebula.widgets.xviewer.Activator;
import org.eclipse.nebula.widgets.xviewer.IXViewerLabelProvider;
import org.eclipse.nebula.widgets.xviewer.IXViewerPreComputedColumn;
import org.eclipse.nebula.widgets.xviewer.IXViewerValueColumn;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.XViewerLabelProvider;
import org.eclipse.nebula.widgets.xviewer.XViewerText;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.nebula.widgets.xviewer.util.XViewerException;
import org.eclipse.nebula.widgets.xviewer.util.internal.HtmlUtil;
import org.eclipse.nebula.widgets.xviewer.util.internal.XViewerLog;
import org.eclipse.nebula.widgets.xviewer.util.internal.dialog.HtmlDialog;
import org.eclipse.nebula.widgets.xviewer.util.internal.images.XViewerImageCache;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class ViewSelectedCellDataAction
extends Action {
    private final XViewer xViewer;
    private final Option option;
    private final Clipboard clipboard;

    public ViewSelectedCellDataAction(XViewer xViewer, Clipboard clipboard, Option option) {
        super(option.equals((Object)Option.View) ? XViewerText.get("action.selectedCellData.view") : XViewerText.get("action.selectedCellData.copy"));
        this.xViewer = xViewer;
        this.clipboard = clipboard;
        this.option = option;
    }

    public ImageDescriptor getImageDescriptor() {
        return XViewerImageCache.getImageDescriptor("report.gif");
    }

    public void run() {
        try {
            TreeColumn treeCol = this.xViewer.getRightClickSelectedColumn();
            TreeItem treeItem = this.xViewer.getRightClickSelectedItem();
            this.run(treeCol, treeItem, this.xViewer.getRightClickSelectedColumnNum());
        }
        catch (Exception ex) {
            XViewerLog.logAndPopup(Activator.class, Level.SEVERE, ex);
        }
    }

    public void run(TreeColumn treeCol, TreeItem treeItem, int columnNum) throws XViewerException, Exception {
        if (treeCol != null) {
            XViewerColumn xCol = (XViewerColumn)treeCol.getData();
            String data = null;
            data = xCol instanceof IXViewerValueColumn ? ((IXViewerValueColumn)xCol).getColumnText(treeItem.getData(), xCol, columnNum) : (xCol instanceof IXViewerPreComputedColumn ? XViewerLabelProvider.getPrecomputedText(treeItem.getData(), xCol, (IXViewerPreComputedColumn)xCol, false) : ((IXViewerLabelProvider)this.xViewer.getLabelProvider()).getColumnText(treeItem.getData(), xCol, columnNum));
            if (data != null && !data.equals("")) {
                if (this.option == Option.View) {
                    String html = HtmlUtil.simplePage(HtmlUtil.getPreData(data));
                    new HtmlDialog(String.valueOf(treeCol.getText()) + " " + XViewerText.get("data"), String.valueOf(treeCol.getText()) + " " + XViewerText.get("data"), html).open();
                } else {
                    this.clipboard.setContents(new Object[]{data}, new Transfer[]{TextTransfer.getInstance()});
                }
            }
        }
    }

    public static enum Option {
        View,
        Copy;

    }
}

