/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer.customize;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.nebula.widgets.xviewer.Activator;
import org.eclipse.nebula.widgets.xviewer.IXViewerLabelProvider;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.XViewerColumnLabelProvider;
import org.eclipse.nebula.widgets.xviewer.XViewerColumnSorter;
import org.eclipse.nebula.widgets.xviewer.XViewerComputedColumn;
import org.eclipse.nebula.widgets.xviewer.XViewerText;
import org.eclipse.nebula.widgets.xviewer.action.ColumnMultiEditAction;
import org.eclipse.nebula.widgets.xviewer.action.TableCustomizationAction;
import org.eclipse.nebula.widgets.xviewer.action.ViewLoadingReportAction;
import org.eclipse.nebula.widgets.xviewer.action.ViewSelectedCellDataAction;
import org.eclipse.nebula.widgets.xviewer.action.ViewTableReportAction;
import org.eclipse.nebula.widgets.xviewer.core.model.CustomizeData;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.nebula.widgets.xviewer.core.util.CollectionsUtil;
import org.eclipse.nebula.widgets.xviewer.util.internal.ArrayTreeContentProvider;
import org.eclipse.nebula.widgets.xviewer.util.internal.HtmlUtil;
import org.eclipse.nebula.widgets.xviewer.util.internal.PatternFilter;
import org.eclipse.nebula.widgets.xviewer.util.internal.XViewerLib;
import org.eclipse.nebula.widgets.xviewer.util.internal.XViewerLog;
import org.eclipse.nebula.widgets.xviewer.util.internal.XViewerPatternFilter;
import org.eclipse.nebula.widgets.xviewer.util.internal.dialog.HtmlDialog;
import org.eclipse.nebula.widgets.xviewer.util.internal.dialog.XCheckFilteredTreeDialog;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.ListDialog;

public class XViewerCustomMenu {
    protected XViewer xViewer;
    private final Clipboard clipboard = new Clipboard(null);
    private static final Pattern NUMERIC_PATTERN = Pattern.compile("-?\\d+(\\.\\d+)?");
    protected Action filterByValue;
    protected Action filterByColumn;
    protected Action filterBySelColumn;
    protected Action clearAllSorting;
    protected Action clearAllFilters;
    protected Action tableProperties;
    protected Action viewTableReport;
    protected Action columnMultiEdit;
    protected Action removeSelected;
    protected Action removeNonSelected;
    protected Action viewLoadingReport;
    protected Action copySelected;
    protected Action showColumn;
    protected Action addComputedColumn;
    protected Action sumColumn;
    protected Action averageColumn;
    protected Action hideColumn;
    protected Action copySelectedColumnCells;
    protected Action viewSelectedCell;
    protected Action copySelectedCell;
    protected Action uniqueValues;
    private boolean headerMouseClick = false;
    private static PatternFilter patternFilter = new XViewerPatternFilter();
    static LabelProvider treeColumnLabelProvider = new LabelProvider(){

        public String getText(Object element) {
            if (element instanceof TreeColumn) {
                return ((TreeColumn)element).getText();
            }
            return XViewerText.get("error.unknown_element");
        }
    };
    static ViewerSorter treeColumnSorter = new ViewerSorter(){

        public int compare(Viewer viewer, Object e1, Object e2) {
            return this.getComparator().compare(((TreeColumn)e1).getText(), ((TreeColumn)e2).getText());
        }
    };

    public boolean isHeaderMouseClick() {
        return this.headerMouseClick;
    }

    public XViewerCustomMenu() {
    }

    public XViewerCustomMenu(XViewer xViewer) {
        this.xViewer = xViewer;
    }

    public void init(final XViewer xviewer) {
        this.xViewer = xviewer;
        this.setupActions();
        this.xViewer.getTree().addListener(2, e -> {
            if (e.keyCode == 99 && e.stateMask == 393216) {
                this.performCopyColumnCells();
            } else if (e.keyCode == 98 && e.stateMask == 393216) {
                this.performViewOrCopyCell(ViewSelectedCellDataAction.Option.Copy);
            } else if (e.keyCode == 118 && e.stateMask == 393216) {
                this.performViewOrCopyCell(ViewSelectedCellDataAction.Option.View);
            } else if (e.keyCode == 99 && e.stateMask == 262144) {
                this.performCopy();
            }
        });
        this.xViewer.getTree().addListener(12, e -> {
            if (this.clipboard != null) {
                this.clipboard.dispose();
            }
        });
        this.xViewer.getMenuManager().addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                if (XViewerCustomMenu.this.headerMouseClick) {
                    XViewerCustomMenu.this.setupMenuForHeader();
                    xviewer.updateMenuActionsForHeader();
                } else {
                    XViewerCustomMenu.this.setupMenuForTable();
                    XViewerCustomMenu.this.xViewer.updateMenuActionsForTable();
                }
            }
        });
        this.xViewer.getTree().addListener(35, event -> {
            Point pt = Display.getCurrent().map(null, (Control)this.xViewer.getTree(), new Point(event.x, event.y));
            Rectangle clientArea = this.xViewer.getTree().getClientArea();
            this.headerMouseClick = clientArea.y <= pt.y && pt.y < clientArea.y + this.xViewer.getTree().getHeaderHeight();
        });
    }

    protected void setupMenuForHeader() {
        MenuManager mm = this.xViewer.getMenuManager();
        this.setupMenuForHeader(mm);
    }

    public void setupMenuForHeader(MenuManager menuManager) {
        menuManager.add((IAction)this.showColumn);
        menuManager.add((IAction)this.hideColumn);
        menuManager.add((IAction)this.addComputedColumn);
        menuManager.add((IAction)this.copySelectedColumnCells);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.filterBySelColumn);
        menuManager.add((IAction)this.filterByColumn);
        menuManager.add((IAction)this.clearAllFilters);
        menuManager.add((IAction)this.clearAllSorting);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.sumColumn);
        menuManager.add((IAction)this.averageColumn);
        menuManager.add((IAction)this.uniqueValues);
    }

    protected void setupMenuForTable() {
        MenuManager mm = this.xViewer.getMenuManager();
        this.setupMenuForTable(mm);
    }

    public void setupMenuForTable(MenuManager menuManager) {
        menuManager.add((IContributionItem)new GroupMarker("XVIEWER MENU GROUP PRE"));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.tableProperties);
        menuManager.add((IAction)this.viewTableReport);
        if (this.xViewer.isColumnMultiEditEnabled()) {
            menuManager.add((IAction)this.columnMultiEdit);
        }
        menuManager.add((IAction)this.viewSelectedCell);
        menuManager.add((IAction)this.copySelectedCell);
        menuManager.add((IAction)this.copySelected);
        menuManager.add((IAction)this.copySelectedColumnCells);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.filterByValue);
        menuManager.add((IAction)this.filterByColumn);
        menuManager.add((IAction)this.clearAllFilters);
        menuManager.add((IAction)this.clearAllSorting);
        if (this.xViewer.isRemoveItemsMenuOptionEnabled()) {
            menuManager.add((IContributionItem)new Separator());
            menuManager.add((IAction)this.removeSelected);
            menuManager.add((IAction)this.removeNonSelected);
        }
        if (this.xViewer.isDebugLoading()) {
            menuManager.add((IContributionItem)new Separator());
            menuManager.add((IAction)this.viewLoadingReport);
        }
        menuManager.add((IContributionItem)new GroupMarker("XVIEWER MENU GROUP POST"));
    }

    public void updateEditMenu(MenuManager mm) {
        List<TreeItem> selectedTreeItems = Arrays.asList(this.xViewer.getTree().getSelection());
        Set<TreeColumn> editableColumns = ColumnMultiEditAction.getEditableTreeColumns(this.xViewer, selectedTreeItems);
        MenuManager editMenuManager = XViewerCustomMenu.createEditMenuManager(this.xViewer, XViewerText.get("menu.edit.multi"), selectedTreeItems, editableColumns);
        mm.add((IContributionItem)editMenuManager);
    }

    public static MenuManager createEditMenuManager(final XViewer xViewer, String name, final Collection<TreeItem> selectedTreeItems, Set<TreeColumn> editableColumns) {
        MenuManager editMenuManager = new MenuManager(name, XViewerText.get("menu.edit"));
        if (editableColumns.isEmpty()) {
            editMenuManager.add((IAction)new Action(XViewerText.get("menu.edit.no_columns")){

                public void run() {
                    XViewerLib.popup(XViewerText.get("error"), XViewerText.get("error.no_fields.multi_editable"));
                }
            });
        } else {
            HashMap<String, TreeColumn> nameToColumn = new HashMap<String, TreeColumn>();
            for (TreeColumn treeColumn : editableColumns) {
                nameToColumn.put(treeColumn.getText(), treeColumn);
            }
            Object[] names = nameToColumn.keySet().toArray(new String[nameToColumn.size()]);
            Arrays.sort(names);
            Object[] objectArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                XViewerColumn xCol;
                Object columnName = objectArray[n2];
                final TreeColumn treeColumn = (TreeColumn)nameToColumn.get(columnName);
                if (treeColumn.getData() instanceof XViewerColumn && (xCol = (XViewerColumn)treeColumn.getData()).isMultiColumnEditable()) {
                    editMenuManager.add((IAction)new Action(String.valueOf(XViewerText.get("menu.edit")) + " " + xCol.getName()){

                        public void run() {
                            xViewer.handleColumnMultiEdit(treeColumn, selectedTreeItems);
                        }
                    });
                }
                ++n2;
            }
        }
        return editMenuManager;
    }

    public void createTableCustomizationMenuItem(Menu popupMenu) {
        new ActionContributionItem((IAction)this.xViewer.getCustomizeActionWithoutDropDown()).fill(popupMenu, -1);
    }

    public void createViewTableReportMenuItem(Menu popupMenu) {
        this.setupActions();
        MenuItem item = new MenuItem(popupMenu, 64);
        item.setText(XViewerText.get("menu.view_report"));
        item.addListener(13, e -> this.viewTableReport.run());
    }

    public void addFilterMenuBlock(Menu popupMenu) {
        this.createFilterByColumnMenuItem(popupMenu);
        this.createClearAllFiltersMenuItem(popupMenu);
        this.createClearAllSortingMenuItem(popupMenu);
    }

    public void createFilterByColumnMenuItem(Menu popupMenu) {
        MenuItem item = new MenuItem(popupMenu, 64);
        item.setText(XViewerText.get("menu.column_filter"));
        item.addListener(13, e -> this.performFilterByColumn());
    }

    public void createFilterByValueMenuItem(Menu popupMenu) {
        MenuItem item = new MenuItem(popupMenu, 64);
        item.setText(XViewerText.get("menu.value_filter"));
        item.addListener(13, e -> this.performFilterByValue());
    }

    public void createClearAllFiltersMenuItem(Menu popupMenu) {
        MenuItem item = new MenuItem(popupMenu, 64);
        item.setText(XViewerText.get("menu.clear_filters"));
        item.addListener(13, e -> this.xViewer.getCustomizeMgr().clearFilters());
    }

    public void createClearAllSortingMenuItem(Menu popupMenu) {
        MenuItem item = new MenuItem(popupMenu, 64);
        item.setText(XViewerText.get("menu.clear_sorts"));
        item.addListener(13, e -> this.xViewer.getCustomizeMgr().clearSorter());
    }

    public void addCopyViewMenuBlock(Menu popupMenu) {
        this.createViewSelectedCellMenuItem(popupMenu);
        this.createCopyRowsMenuItem(popupMenu);
        this.createCopyCellsMenuItem(popupMenu);
    }

    public void createCopyRowsMenuItem(Menu popupMenu) {
        MenuItem item = new MenuItem(popupMenu, 64);
        item.setText(XViewerText.get("menu.copy_row"));
        item.addListener(13, e -> this.performCopy());
    }

    public void createCopyCellsMenuItem(Menu popupMenu) {
        MenuItem item = new MenuItem(popupMenu, 64);
        item.setText(XViewerText.get("menu.copy_column"));
        item.addListener(13, e -> this.performCopyColumnCells());
    }

    public void createViewSelectedCellMenuItem(Menu popupMenu) {
        this.setupActions();
        MenuItem item = new MenuItem(popupMenu, 64);
        item.setText(XViewerText.get("menu.copy_celldata"));
        item.addListener(13, e -> this.copySelectedCell.run());
        MenuItem item1 = new MenuItem(popupMenu, 64);
        item1.setText(XViewerText.get("menu.view_celldata"));
        item1.addListener(13, e -> this.viewSelectedCell.run());
    }

    protected void handleShowColumn() {
        TreeColumn insertTreeCol = this.xViewer.getRightClickSelectedColumn();
        XViewerColumn insertXCol = insertTreeCol != null ? (XViewerColumn)insertTreeCol.getData() : null;
        XCheckFilteredTreeDialog dialog = new XCheckFilteredTreeDialog(XViewerText.get("dialog.show_columns.title"), XViewerText.get("dialog.show_columns.prompt"), patternFilter, (IContentProvider)new ArrayTreeContentProvider(), (IBaseLabelProvider)new XViewerColumnLabelProvider(), new XViewerColumnSorter());
        dialog.setInput(this.xViewer.getCustomizeMgr().getCurrentTableColumns());
        if (dialog.open() == 0) {
            CustomizeData custData = this.xViewer.getCustomizeMgr().generateCustDataFromTable();
            List xCols = custData.getColumnData().getColumns();
            ArrayList<XViewerColumn> newXCols = new ArrayList<XViewerColumn>();
            if (insertXCol == null) {
                for (XViewerColumn currXCol : xCols) {
                    if (currXCol.isShow()) continue;
                    insertXCol = currXCol;
                    break;
                }
            }
            for (XViewerColumn currXCol : xCols) {
                if (currXCol.equals((Object)insertXCol)) {
                    for (Object obj : dialog.getChecked()) {
                        XViewerColumn newXCol = (XViewerColumn)obj;
                        newXCol.setShow(true);
                        newXCols.add(newXCol);
                    }
                }
                if (dialog.getChecked().contains(currXCol)) continue;
                newXCols.add(currXCol);
            }
            custData.getColumnData().setColumns(newXCols);
            this.xViewer.getCustomizeMgr().loadCustomization(custData);
            this.xViewer.refreshColumnsWithPreCompute();
        }
    }

    protected void handleAddComputedColumn() {
        TreeColumn insertTreeCol = this.xViewer.getRightClickSelectedColumn();
        XViewerColumn insertXCol = (XViewerColumn)insertTreeCol.getData();
        XCheckFilteredTreeDialog dialog = new XCheckFilteredTreeDialog("", XViewerText.get("dialog.add_column.prompt", insertXCol.getName(), insertXCol.getId()), patternFilter, (IContentProvider)new ArrayTreeContentProvider(), (IBaseLabelProvider)new XViewerColumnLabelProvider(), new XViewerColumnSorter());
        Collection<XViewerComputedColumn> computedCols = this.xViewer.getComputedColumns(insertXCol);
        if (computedCols.isEmpty()) {
            XViewerLib.popup(XViewerText.get("error"), XViewerText.get("error.no_computed"));
            return;
        }
        dialog.setInput(computedCols);
        if (dialog.open() == 0) {
            CustomizeData custData = this.xViewer.getCustomizeMgr().generateCustDataFromTable();
            List xCols = custData.getColumnData().getColumns();
            ArrayList<XViewerColumn> newXCols = new ArrayList<XViewerColumn>();
            for (XViewerColumn currXCol : xCols) {
                if (currXCol.equals((Object)insertXCol)) {
                    for (Object obj : dialog.getChecked()) {
                        XViewerComputedColumn newComputedXCol = ((XViewerComputedColumn)obj).copy();
                        newComputedXCol.setShow(true);
                        newComputedXCol.setSourceXViewerColumn(insertXCol);
                        newComputedXCol.setXViewer((Object)this.xViewer);
                        newXCols.add(newComputedXCol);
                    }
                }
                newXCols.add(currXCol);
            }
            custData.getColumnData().setColumns(newXCols);
            this.xViewer.getCustomizeMgr().loadCustomization(custData);
            this.xViewer.refresh();
        }
    }

    protected void handleUniqeValuesColumn() {
        TreeColumn treeCol = this.xViewer.getRightClickSelectedColumn();
        XViewerColumn xCol = (XViewerColumn)treeCol.getData();
        TreeItem[] items = this.xViewer.getTree().getSelection();
        if (items.length == 0) {
            items = this.xViewer.getTree().getItems();
        }
        if (items.length == 0) {
            XViewerLib.popup(XViewerText.get("error"), XViewerText.get("error.no_items.sum"));
            return;
        }
        HashSet<String> values = new HashSet<String>();
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            int x = 0;
            while (x < this.xViewer.getTree().getColumnCount()) {
                if (this.xViewer.getTree().getColumn(x).equals(treeCol)) {
                    values.add(((IXViewerLabelProvider)this.xViewer.getLabelProvider()).getColumnText(item.getData(), x));
                }
                ++x;
            }
            ++n2;
        }
        String html = HtmlUtil.simplePage(HtmlUtil.textToHtml(CollectionsUtil.toString((String)"\n", values)));
        new HtmlDialog(XViewerText.get("dialog.unique.title"), XViewerText.get("dialog.unique.prompt", xCol.getName()), html).open();
    }

    protected void handleSumColumn() {
        TreeColumn treeCol = this.xViewer.getRightClickSelectedColumn();
        XViewerColumn xCol = (XViewerColumn)treeCol.getData();
        TreeItem[] items = this.xViewer.getTree().getSelection();
        if (items.length == 0) {
            items = this.xViewer.getTree().getItems();
        }
        if (items.length == 0) {
            XViewerLib.popup(XViewerText.get("error"), XViewerText.get("error.no_items.sum"));
            return;
        }
        ArrayList<String> values = new ArrayList<String>();
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            int x = 0;
            while (x < this.xViewer.getTree().getColumnCount()) {
                if (this.xViewer.getTree().getColumn(x).equals(treeCol)) {
                    String val = ((IXViewerLabelProvider)this.xViewer.getLabelProvider()).getColumnText(item.getData(), x);
                    if (xCol.isSummable()) {
                        values.add(val);
                    } else {
                        boolean result = false;
                        if (val != null && !val.isBlank()) {
                            Matcher matcher = NUMERIC_PATTERN.matcher(val);
                            result = matcher.matches();
                        }
                        if (result) {
                            values.add(val);
                        }
                    }
                }
                ++x;
            }
            ++n2;
        }
        XViewerLib.popup(XViewerText.get("menu.sum.prompt"), xCol.sumValues(values));
    }

    protected void handleAverageColumn() {
        TreeColumn treeCol = this.xViewer.getRightClickSelectedColumn();
        XViewerColumn xCol = (XViewerColumn)treeCol.getData();
        if (!xCol.isSummable()) {
            XViewerLib.popup("Invalid Selection for Average", String.format("Average not available for column [%s]", xCol.getName()));
            return;
        }
        TreeItem[] items = this.xViewer.getTree().getSelection();
        if (items.length == 0) {
            items = this.xViewer.getTree().getItems();
        }
        if (items.length == 0) {
            XViewerLib.popup(XViewerText.get("error"), XViewerText.get("error.no_items.average"));
            return;
        }
        ArrayList<String> values = new ArrayList<String>();
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            int x = 0;
            while (x < this.xViewer.getTree().getColumnCount()) {
                if (this.xViewer.getTree().getColumn(x).equals(treeCol)) {
                    values.add(((IXViewerLabelProvider)this.xViewer.getLabelProvider()).getColumnText(item.getData(), x));
                }
                ++x;
            }
            ++n2;
        }
        XViewerLib.popup(XViewerText.get("menu.sum.prompt"), xCol.averageValues(values));
    }

    protected void handleHideColumn() {
        TreeColumn insertTreeCol = this.xViewer.getRightClickSelectedColumn();
        XViewerColumn insertXCol = (XViewerColumn)insertTreeCol.getData();
        CustomizeData custData = this.xViewer.getCustomizeMgr().generateCustDataFromTable();
        List xCols = custData.getColumnData().getColumns();
        ArrayList<XViewerColumn> newXCols = new ArrayList<XViewerColumn>();
        for (XViewerColumn currXCol : xCols) {
            if (currXCol.equals((Object)insertXCol)) {
                currXCol.setShow(false);
            }
            newXCols.add(currXCol);
        }
        custData.getColumnData().setColumns(newXCols);
        this.xViewer.getCustomizeMgr().loadCustomization(custData);
        this.xViewer.refresh();
    }

    protected void setupActions() {
        this.showColumn = new Action(XViewerText.get("menu.show")){

            public void run() {
                XViewerCustomMenu.this.handleShowColumn();
            }
        };
        this.addComputedColumn = new Action(XViewerText.get("menu.add")){

            public void run() {
                XViewerCustomMenu.this.handleAddComputedColumn();
            }
        };
        this.sumColumn = new Action(XViewerText.get("menu.sum")){

            public void run() {
                XViewerCustomMenu.this.handleSumColumn();
            }
        };
        this.averageColumn = new Action(XViewerText.get("menu.average")){

            public void run() {
                XViewerCustomMenu.this.handleAverageColumn();
            }
        };
        this.uniqueValues = new Action(XViewerText.get("menu.unique")){

            public void run() {
                XViewerCustomMenu.this.handleUniqeValuesColumn();
            }
        };
        this.hideColumn = new Action(XViewerText.get("menu.hide")){

            public void run() {
                XViewerCustomMenu.this.handleHideColumn();
            }
        };
        this.removeSelected = new Action(XViewerText.get("menu.remove_selected")){

            public void run() {
                XViewerCustomMenu.this.performRemoveSelectedRows();
            }
        };
        this.removeNonSelected = new Action(XViewerText.get("menu.remove_non_selected")){

            public void run() {
                XViewerCustomMenu.this.performRemoveNonSelectedRows();
            }
        };
        this.copySelected = new Action(XViewerText.get("menu.copy_row")){

            public void run() {
                XViewerCustomMenu.this.performCopy();
            }
        };
        this.viewSelectedCell = new ViewSelectedCellDataAction(this.xViewer, null, ViewSelectedCellDataAction.Option.View);
        this.copySelectedCell = new ViewSelectedCellDataAction(this.xViewer, this.clipboard, ViewSelectedCellDataAction.Option.Copy);
        this.copySelectedColumnCells = new Action(XViewerText.get("menu.copy_column")){

            public void run() {
                XViewerCustomMenu.this.performCopyColumnCells();
            }
        };
        this.clearAllSorting = new Action(XViewerText.get("menu.clear_sorts")){

            public void run() {
                XViewerCustomMenu.this.xViewer.getCustomizeMgr().clearSorter();
            }
        };
        this.clearAllFilters = new Action(XViewerText.get("menu.clear_filters")){

            public void run() {
                XViewerCustomMenu.this.xViewer.getCustomizeMgr().clearFilters();
            }
        };
        this.filterBySelColumn = new Action(XViewerText.get("menu.column_filter_sel")){

            public void run() {
                XViewerCustomMenu.this.performFilterBySelColumn();
            }
        };
        this.filterByColumn = new Action(XViewerText.get("menu.column_filter")){

            public void run() {
                XViewerCustomMenu.this.performFilterByColumn();
            }
        };
        this.filterByValue = new Action(XViewerText.get("menu.value_filter")){

            public void run() {
                XViewerCustomMenu.this.performFilterByValue();
            }
        };
        this.tableProperties = new TableCustomizationAction(this.xViewer);
        this.viewTableReport = new ViewTableReportAction(this.xViewer);
        this.viewLoadingReport = new ViewLoadingReportAction(this.xViewer);
        this.columnMultiEdit = new ColumnMultiEditAction(this.xViewer);
    }

    private void performRemoveSelectedRows() {
        try {
            TreeItem[] items = this.xViewer.getTree().getSelection();
            if (items.length == 0) {
                XViewerLib.popup(XViewerText.get("error"), XViewerText.get("error.no_items"));
                return;
            }
            HashSet<Object> objs = new HashSet<Object>();
            TreeItem[] treeItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                objs.add(item.getData());
                ++n2;
            }
            this.xViewer.remove(objs);
        }
        catch (Exception ex) {
            XViewerLog.logAndPopup(Activator.class, Level.SEVERE, ex);
        }
    }

    private void performRemoveNonSelectedRows() {
        try {
            TreeItem[] items = this.xViewer.getTree().getSelection();
            if (items.length == 0) {
                XViewerLib.popup(XViewerText.get("error"), XViewerText.get("error.no_items"));
                return;
            }
            HashSet<Object> keepObjects = new HashSet<Object>();
            TreeItem[] treeItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                keepObjects.add(item.getData());
                ++n2;
            }
            this.xViewer.setInputXViewer(keepObjects);
        }
        catch (Exception ex) {
            XViewerLog.logAndPopup(Activator.class, Level.SEVERE, ex);
        }
    }

    private void performFilterByValue() {
        TreeColumn treeCol = this.xViewer.getRightClickSelectedColumn();
        String colId = ((XViewerColumn)treeCol.getData()).getId();
        int colIndex = this.xViewer.getRightClickSelectedColumnNum();
        TreeItem treeItem = this.xViewer.getRightClickSelectedItem();
        String cellVal = treeItem.getText(colIndex);
        this.xViewer.getCustomizeMgr().setColumnFilterText(colId, cellVal);
    }

    private void performFilterByColumn() {
        HashSet<TreeColumn> visibleColumns = new HashSet<TreeColumn>();
        TreeColumn[] treeColumnArray = this.xViewer.getTree().getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn treeCol = treeColumnArray[n2];
            if (treeCol.getWidth() > 0) {
                visibleColumns.add(treeCol);
            }
            ++n2;
        }
        if (visibleColumns.isEmpty()) {
            XViewerLib.popup(XViewerText.get("error"), XViewerText.get("error.no_columns"));
            return;
        }
        ListDialog ld = new ListDialog(this.xViewer.getTree().getShell()){

            protected Control createDialogArea(Composite container) {
                Control control = super.createDialogArea(container);
                this.getTableViewer().setSorter(treeColumnSorter);
                return control;
            }
        };
        ld.setMessage(XViewerText.get("dialog.column_filter.title"));
        ld.setInput(visibleColumns);
        ld.setLabelProvider((ILabelProvider)treeColumnLabelProvider);
        ld.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        ld.setTitle(XViewerText.get("dialog.column_filter.title"));
        int result = ld.open();
        if (result != 0) {
            return;
        }
        TreeColumn treeCol = (TreeColumn)ld.getResult()[0];
        XViewerColumn col = (XViewerColumn)treeCol.getData();
        this.xViewer.getColumnFilterDataUI().promptSetFilter(col);
    }

    private void performFilterBySelColumn() {
        XViewerColumn col = (XViewerColumn)this.xViewer.getRightClickSelectedColumn().getData();
        this.xViewer.getColumnFilterDataUI().promptSetFilter(col);
    }

    private void performCopyColumnCells() {
        HashSet<TreeColumn> visibleColumns = new HashSet<TreeColumn>();
        TreeItem[] items = this.xViewer.getTree().getSelection();
        if (items.length == 0) {
            XViewerLib.popup(XViewerText.get("error"), XViewerText.get("error.no_selection"));
            return;
        }
        ArrayList<String> textTransferData = new ArrayList<String>();
        IXViewerLabelProvider labelProv = (IXViewerLabelProvider)this.xViewer.getLabelProvider();
        TreeColumn[] treeColumnArray = this.xViewer.getTree().getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn treeCol = treeColumnArray[n2];
            if (treeCol.getWidth() > 0) {
                visibleColumns.add(treeCol);
            }
            ++n2;
        }
        if (visibleColumns.isEmpty()) {
            XViewerLib.popup(XViewerText.get("error"), XViewerText.get("error.no_columns"));
            return;
        }
        ListDialog ld = new ListDialog(this.xViewer.getTree().getShell()){

            protected Control createDialogArea(Composite container) {
                Control control = super.createDialogArea(container);
                this.getTableViewer().setSorter(treeColumnSorter);
                return control;
            }
        };
        ld.setMessage(XViewerText.get("dialog.copy_column.title"));
        ld.setInput(visibleColumns);
        ld.setLabelProvider((ILabelProvider)treeColumnLabelProvider);
        ld.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        ld.setTitle(XViewerText.get("dialog.copy_column.title"));
        int result = ld.open();
        if (result != 0) {
            return;
        }
        TreeColumn treeCol = (TreeColumn)ld.getResult()[0];
        StringBuilder sb = new StringBuilder();
        TreeItem[] treeItemArray = items;
        int n3 = items.length;
        int n4 = 0;
        while (n4 < n3) {
            TreeItem item = treeItemArray[n4];
            int x = 0;
            while (x < this.xViewer.getTree().getColumnCount()) {
                if (this.xViewer.getTree().getColumn(x).equals(treeCol)) {
                    sb.append(labelProv.getColumnText(item.getData(), x));
                    sb.append("\n");
                }
                ++x;
            }
            ++n4;
        }
        textTransferData.add(sb.toString());
        if (textTransferData.size() > 0) {
            this.clipboard.setContents(new Object[]{CollectionsUtil.toString(textTransferData, null, (String)", ", null)}, new Transfer[]{TextTransfer.getInstance()});
        }
    }

    private void performCopy() {
        TreeItem[] items = this.xViewer.getTree().getSelection();
        if (items.length == 0) {
            XViewerLib.popup(XViewerText.get("error"), XViewerText.get("error.no_items"));
            return;
        }
        ArrayList<String> textTransferData = new ArrayList<String>();
        IXViewerLabelProvider labelProv = (IXViewerLabelProvider)this.xViewer.getLabelProvider();
        if (items.length > 0) {
            StringBuilder sb = new StringBuilder();
            TreeItem[] treeItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                ArrayList<String> strs = new ArrayList<String>();
                int x = 0;
                while (x < this.xViewer.getTree().getColumnCount()) {
                    String data;
                    if (this.xViewer.getTree().getColumn(x).getWidth() > 0 && (data = labelProv.getColumnText(item.getData(), x)) != null) {
                        strs.add(data);
                    }
                    ++x;
                }
                sb.append(CollectionsUtil.toString((String)"\t", strs));
                sb.append("\n");
                ++n2;
            }
            textTransferData.add(sb.toString());
            if (textTransferData.size() > 0) {
                this.clipboard.setContents(new Object[]{CollectionsUtil.toString(textTransferData, null, (String)", ", null)}, new Transfer[]{TextTransfer.getInstance()});
            }
        }
    }

    private void performViewOrCopyCell(ViewSelectedCellDataAction.Option option) {
        try {
            MouseEvent event = this.xViewer.getMouseListener().getLeftClickEvent();
            TreeItem item = this.xViewer.getItemUnderMouseClick(new Point(event.x, event.y));
            TreeColumn column = this.xViewer.getColumnUnderMouseClick(new Point(event.x, event.y));
            if (item != null && column != null) {
                int columnNum = 0;
                int x = 0;
                while (x < this.xViewer.getTree().getColumnCount()) {
                    if (this.xViewer.getTree().getColumn(x).equals(column)) {
                        columnNum = x;
                        break;
                    }
                    ++x;
                }
                ViewSelectedCellDataAction action = new ViewSelectedCellDataAction(this.xViewer, this.clipboard, option);
                action.run(column, item, columnNum);
            }
        }
        catch (Exception exception) {}
    }
}

