/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.data.computed;

import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.ComputedCharacteristicEnum;
import org.eclipse.osee.framework.core.data.NamespaceToken;
import org.eclipse.osee.framework.core.data.TaggerTypeToken;
import org.eclipse.osee.framework.core.enums.EnumToken;
import org.eclipse.osee.framework.core.enums.token.SafetySeverityAttributeType;
import org.eclipse.osee.framework.core.enums.token.SoftwareControlCategoryAttributeType;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;

public final class ComputedSoftwareCriticalityIndex
extends ComputedCharacteristicEnum<EnumToken> {
    public final SoftwareCriticalityIndexEnum Unspecified = new SoftwareCriticalityIndexEnum(0, "Unspecified");
    public final SoftwareCriticalityIndexEnum SwCI1 = new SoftwareCriticalityIndexEnum(1, "SwCI 1");
    public final SoftwareCriticalityIndexEnum SwCI2 = new SoftwareCriticalityIndexEnum(2, "SwCI 2");
    public final SoftwareCriticalityIndexEnum SwCI3 = new SoftwareCriticalityIndexEnum(3, "SwCI 3");
    public final SoftwareCriticalityIndexEnum SwCI4 = new SoftwareCriticalityIndexEnum(4, "SwCI 4");
    public final SoftwareCriticalityIndexEnum SwCI5 = new SoftwareCriticalityIndexEnum(5, "SwCI 5");
    public final SoftwareCriticalityIndexEnum[][] softwareCriticalityMatrix = new SoftwareCriticalityIndexEnum[][]{{this.SwCI1, this.SwCI1, this.SwCI3, this.SwCI4}, {this.SwCI1, this.SwCI2, this.SwCI3, this.SwCI4}, {this.SwCI2, this.SwCI3, this.SwCI4, this.SwCI4}, {this.SwCI3, this.SwCI4, this.SwCI4, this.SwCI4}, {this.SwCI5, this.SwCI5, this.SwCI5, this.SwCI5}};

    public ComputedSoftwareCriticalityIndex(Long id, String name, TaggerTypeToken taggerType, NamespaceToken namespace, String description, List<AttributeTypeGeneric<EnumToken>> typesToCompute) {
        super(id, name, taggerType, namespace, description, typesToCompute, 6);
    }

    @Override
    public boolean isMultiplicityValid(ArtifactTypeToken artifactType) {
        return this.exactlyTwoValues(artifactType);
    }

    @Override
    public EnumToken calculate(List<EnumToken> computingValues) {
        int safetySeverity;
        int softwareControlCategory;
        if (computingValues.get(0) instanceof SoftwareControlCategoryAttributeType.SoftwareControlCategoryEnum && computingValues.get(1) instanceof SafetySeverityAttributeType.SafetySeverityEnum) {
            softwareControlCategory = computingValues.get(0).getIdIntValue();
            safetySeverity = computingValues.get(1).getIdIntValue();
        } else if (computingValues.get(0) instanceof SafetySeverityAttributeType.SafetySeverityEnum && computingValues.get(1) instanceof SoftwareControlCategoryAttributeType.SoftwareControlCategoryEnum) {
            safetySeverity = computingValues.get(0).getIdIntValue();
            softwareControlCategory = computingValues.get(1).getIdIntValue();
        } else {
            throw new OseeCoreException("Invalid inputs [%s] and [%s] used for calculation of Software Criticality Index", new Object[]{computingValues.get(0).getName(), computingValues.get(1).getName()});
        }
        try {
            return this.softwareCriticalityMatrix[softwareControlCategory - 1][safetySeverity];
        }
        catch (Exception exception) {
            return this.Unspecified;
        }
    }

    public class SoftwareCriticalityIndexEnum
    extends EnumToken {
        public SoftwareCriticalityIndexEnum(int ordinal, String name) {
            super(ordinal, name, new NamespaceToken[0]);
            ComputedSoftwareCriticalityIndex.this.addEnum(this);
        }
    }
}

