/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.publishing;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.HashMap;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.osee.framework.core.publishing.IncludeHeadingsDeserializer;
import org.eclipse.osee.framework.core.publishing.IncludeHeadingsSerializer;
import org.eclipse.osee.framework.jdk.core.util.Conditions;

@JsonSerialize(using=IncludeHeadingsSerializer.class)
@JsonDeserialize(using=IncludeHeadingsDeserializer.class)
public enum IncludeHeadings {
    ALWAYS{

        @Override
        public String getOutliningOptionName() {
            return "Always";
        }

        @Override
        public boolean populateEmptyHeaders() {
            return false;
        }
    }
    ,
    NEVER{

        @Override
        public String getOutliningOptionName() {
            return "Never";
        }

        @Override
        public boolean populateEmptyHeaders() {
            return false;
        }
    }
    ,
    ONLY_WITH_NON_HEADING_DESCENDANTS{

        @Override
        public String getOutliningOptionName() {
            return "OnlyWithNonHeadingDescandants";
        }

        @Override
        public boolean populateEmptyHeaders() {
            return true;
        }
    }
    ,
    ONLY_WITH_MAIN_CONTENT{

        @Override
        public String getOutliningOptionName() {
            return "OnlyWithMainContent";
        }

        @Override
        public boolean populateEmptyHeaders() {
            return true;
        }
    };

    static final String jsonObjectName = "includeHeading";
    private static final @NonNull HashMap<@NonNull String, @NonNull IncludeHeadings> members;

    static {
        members = new HashMap();
        IncludeHeadings[] includeHeadingsArray = IncludeHeadings.values();
        int n = includeHeadingsArray.length;
        int n2 = 0;
        while (n2 < n) {
            IncludeHeadings includeHeading = includeHeadingsArray[n2];
            members.put(includeHeading.getOutliningOptionName(), includeHeading);
            ++n2;
        }
    }

    public static Optional<IncludeHeadings> ofOutliningOptionName(@Nullable String outliningOptionName) {
        IncludeHeadings includeHeadings = (IncludeHeadings)((Object)Conditions.applyWhenNonNull((Object)outliningOptionName, members::get));
        return Optional.ofNullable(includeHeadings);
    }

    public abstract String getOutliningOptionName();

    public abstract boolean populateEmptyHeaders();

    public boolean isNever() {
        return this == NEVER;
    }
}

