/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.publishing;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.osee.framework.core.publishing.IncludeMetadataAttributesDeserializer;
import org.eclipse.osee.framework.core.publishing.IncludeMetadataAttributesSerializer;
import org.eclipse.osee.framework.jdk.core.util.Conditions;

@JsonSerialize(using=IncludeMetadataAttributesSerializer.class)
@JsonDeserialize(using=IncludeMetadataAttributesDeserializer.class)
public enum IncludeMetadataAttributes {
    ALWAYS("Always"),
    NEVER("Never"),
    NOT_FOR_HEADINGS("NotForHeadings"),
    ONLY_WITH_MAIN_CONTENT("OnlyWithMainContent"),
    ONLY_WITH_REQUIREMENT_OR_DESIGN_MSWORD("OnlyWithRequirementOrDesignMsWord");

    private static final @NonNull Map<@NonNull String, @NonNull IncludeMetadataAttributes> membersByOptionName;
    static final String jsonObjectName = "includeMetadataAttributes";
    private @NonNull String optionName;

    static {
        membersByOptionName = new HashMap<String, IncludeMetadataAttributes>();
        IncludeMetadataAttributes[] includeMetadataAttributesArray = IncludeMetadataAttributes.values();
        int n = includeMetadataAttributesArray.length;
        int n2 = 0;
        while (n2 < n) {
            IncludeMetadataAttributes member = includeMetadataAttributesArray[n2];
            membersByOptionName.put(member.getOptionName(), member);
            ++n2;
        }
    }

    public static Optional<IncludeMetadataAttributes> ofOptionName(@Nullable String optionName) {
        IncludeMetadataAttributes includeMetadataAttributes = (IncludeMetadataAttributes)((Object)Conditions.applyWhenNonNull((Object)optionName, membersByOptionName::get));
        return Optional.ofNullable(includeMetadataAttributes);
    }

    private IncludeMetadataAttributes(String optionName) {
        this.optionName = (String)Conditions.requireNonNull((Object)optionName, (String)"optionName");
    }

    public @NonNull String getOptionName() {
        return this.optionName;
    }

    public boolean isAlways() {
        return this == ALWAYS;
    }

    public boolean isNever() {
        return this == NEVER;
    }

    public boolean isNotForHeadings() {
        return this == NOT_FOR_HEADINGS;
    }

    public boolean isOnlyWithMainContent() {
        return this == ONLY_WITH_MAIN_CONTENT;
    }

    public boolean isOnlyWithRequirementOrDesignMsWord() {
        return this == ONLY_WITH_REQUIREMENT_OR_DESIGN_MSWORD;
    }
}

