/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.publishing;

import java.util.Objects;
import java.util.Set;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.publishing.artifactacceptor.ArtifactAcceptor;

public class WordRenderApplicabilityChecker
implements ArtifactAcceptor {
    private final NonApplicableArtifactIdLoader nonApplicableArtifactIdLoader;
    private Set<ArtifactId> nonApplicableArtifactIds;

    public WordRenderApplicabilityChecker(NonApplicableArtifactIdLoader nonApplicableArtifactIdLoader) {
        this.nonApplicableArtifactIdLoader = Objects.requireNonNull(nonApplicableArtifactIdLoader, "WordRenderApplicabilityChecker::new, parameter \"nonApplicableArtifactIdLoader\" cannot be null.");
        this.nonApplicableArtifactIds = null;
    }

    public void load(BranchId branchId, ArtifactId viewId) {
        Objects.requireNonNull(branchId, "WordRenderApplicabilityChecker::load, parameter \"branchId\" cannot be null.");
        Objects.requireNonNull(viewId, "WordRenderApplicabilityChecker::load, parameter \"viewId\" cannot be null.");
        int state = (ArtifactId.SENTINEL.equals(branchId.getViewId()) ? 0 : 1) + (ArtifactId.SENTINEL.equals(viewId) ? 0 : 2);
        switch (state) {
            case 0: {
                this.nonApplicableArtifactIds = null;
                break;
            }
            case 1: {
                this.nonApplicableArtifactIds = this.nonApplicableArtifactIdLoader.load(branchId, branchId.getViewId());
                break;
            }
            case 2: {
                this.nonApplicableArtifactIds = this.nonApplicableArtifactIdLoader.load(branchId, viewId);
                break;
            }
            case 3: {
                if (!branchId.getViewId().equals(viewId)) {
                    throw new IllegalArgumentException();
                }
                this.nonApplicableArtifactIds = this.nonApplicableArtifactIdLoader.load(branchId, viewId);
            }
        }
    }

    @Override
    public boolean isOk(ArtifactReadable artifactReadable) {
        return Objects.nonNull(this.nonApplicableArtifactIds) ? !this.nonApplicableArtifactIds.contains(artifactReadable) : true;
    }

    @FunctionalInterface
    public static interface NonApplicableArtifactIdLoader {
        public Set<ArtifactId> load(BranchId var1, ArtifactId var2);
    }
}

