/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.util;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.IUserGroup;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.jdk.core.type.BaseId;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.util.EmailUtil;

public abstract class AbstractUserGroupImpl
extends BaseId
implements IUserGroup,
IUserGroupArtifactToken {
    protected ArtifactToken groupArtifact;

    public AbstractUserGroupImpl(ArtifactToken userGroupArt) {
        super((Id)userGroupArt);
        this.groupArtifact = userGroupArt;
    }

    @Override
    public ArtifactToken getArtifact() {
        this.checkGroupExists();
        return this.groupArtifact;
    }

    protected void checkGroupExists() {
        if (this.groupArtifact == null) {
            this.groupArtifact = this.getOrCreateGroupArtifact(this.groupArtifact);
        }
    }

    public String toString() {
        return "UserGroup: " + this.getArtifact().toStringWithId();
    }

    protected abstract ArtifactToken getOrCreateGroupArtifact(ArtifactToken var1);

    @Override
    public Collection<String> getActiveMemberEmails() {
        ArrayList<String> toUserEmailList = new ArrayList<String>();
        for (UserToken userTok : this.getMembers()) {
            String userEmail;
            if (!userTok.isActive() || !EmailUtil.isEmailValid((String)(userEmail = userTok.getEmail()))) continue;
            toUserEmailList.add(userEmail);
        }
        return toUserEmailList;
    }
}

