/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.util.toggles;

import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.util.toggles.Toggle;
import org.eclipse.osee.framework.core.util.toggles.ToggleAccessor;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.SynchronizedInitializationSupplierUnsynchronizedAccessTriFunction;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.wiring.BundleWiring;

public class TogglesFactory {
    public static final Function<String, Boolean> booleanConverter = TogglesFactory::booleanConverter;
    private static final String clientBundleName = "org.eclipse.osee.framework.core.client";
    private static final String clientDataBaseToggleAccessorFactoryClass = "org.eclipse.osee.framework.core.client.TogglesClientImpl";
    private static final String dataBaseToggleAccessorFactoryMethod = "getDataBaseToggleAccessor";
    private static final Bundle databaseToggleAccessorImplementationBundle;
    private static final SynchronizedInitializationSupplierUnsynchronizedAccessTriFunction<ToggleAccessor, String, Function<String, ?>, Toggle<?>> dataBaseToggleFactory;
    private static final ToggleAccessor defaultToggleAccessor;
    private static final Map<String, String> implementationClasses;
    private static final Location location;
    private static final Map<String, Location> locationMap;
    private static final String manifestHeaderName = "Unloaded-Configuration";
    private static final SynchronizedInitializationSupplierUnsynchronizedAccessTriFunction<ToggleAccessor, String, Function<String, ?>, Toggle<?>> manifestUnloadedConfigurationToggleFactory;
    private static final Map<String, String> manifestUnloadedConfigurationTogglesMap;
    private static final String serverBundleName = "org.eclipse.osee.define";
    private static final String serverDataBaseToggleAccessorFactoryClass = "org.eclipse.osee.define.operations.toggles.TogglesOperationsImpl";
    public static final Function<String, String> stringConverter;

    static {
        dataBaseToggleFactory = new SynchronizedInitializationSupplierUnsynchronizedAccessTriFunction(ToggleAccessor.class, TogglesFactory::create, TogglesFactory::createDataBaseToggleAccessor);
        defaultToggleAccessor = new ToggleAccessor(){

            @Override
            public String getToggle(String name) {
                return Strings.emptyString();
            }

            public String toString() {
                return "defaultToggleAccessor";
            }
        };
        implementationClasses = Map.of(clientBundleName, clientDataBaseToggleAccessorFactoryClass, serverBundleName, serverDataBaseToggleAccessorFactoryClass);
        locationMap = Map.of(clientBundleName, Location.CLIENT, serverBundleName, Location.SERVER);
        manifestUnloadedConfigurationToggleFactory = new SynchronizedInitializationSupplierUnsynchronizedAccessTriFunction(ToggleAccessor.class, TogglesFactory::create, TogglesFactory::createManifestUnloadedConfigurationToggleAccessor);
        stringConverter = TogglesFactory::stringConverter;
        HashMap togglesMap = new HashMap();
        Set<String> bundleNameSet = implementationClasses.keySet();
        Bundle foundBundle = null;
        try {
            List foundBundles = Arrays.stream(FrameworkUtil.getBundle(TogglesFactory.class).getBundleContext().getBundles()).peek(bundle -> TogglesFactory.getUnloadedConfigurationValues(bundle, togglesMap)).filter(bundle -> bundleNameSet.contains(bundle.getSymbolicName())).collect(Collectors.toList());
            if (foundBundles.size() == 1) {
                foundBundle = (Bundle)foundBundles.get(0);
            }
        }
        catch (Exception exception) {}
        manifestUnloadedConfigurationTogglesMap = Collections.unmodifiableMap(togglesMap);
        databaseToggleAccessorImplementationBundle = foundBundle;
        location = Optional.ofNullable(foundBundle).map(bundle -> locationMap.get(bundle.getSymbolicName())).orElse(Location.UNKNOWN);
    }

    private static Boolean booleanConverter(String value) {
        return Boolean.valueOf(value);
    }

    private static <T> Toggle<T> create(final ToggleAccessor toggleAccessor, final String name, final Function<String, T> converter) {
        return new Toggle<T>(){

            @Override
            public T get() {
                return converter.apply(toggleAccessor.getToggle(name));
            }

            public String toString() {
                return new Message().title((CharSequence)"Toggle").indentInc().segment((CharSequence)"Name", (Object)name).segment((CharSequence)"Accessor", (Object)toggleAccessor).toString();
            }
        };
    }

    private static ToggleAccessor createDataBaseToggleAccessor() {
        return Optional.ofNullable(databaseToggleAccessorImplementationBundle).flatMap(TogglesFactory::loadToggleAccessorFactoryClass).flatMap(TogglesFactory::invokeToggleAccessorFactoryMethod).orElse(defaultToggleAccessor);
    }

    private static ToggleAccessor createManifestUnloadedConfigurationToggleAccessor() {
        return manifestUnloadedConfigurationTogglesMap.size() >= 0 ? new ToggleAccessor(){

            @Override
            public String getToggle(String name) {
                return manifestUnloadedConfigurationTogglesMap.get(name);
            }

            public String toString() {
                return "manifestUnloadedConfigurationToggleAccessor";
            }
        } : defaultToggleAccessor;
    }

    public static Location getLocation() {
        return location;
    }

    public static <T> Toggle<T> create(String name, Function<String, T> converter, ToggleSource toggleSource) {
        return toggleSource.create(name, converter);
    }

    private static void getUnloadedConfigurationValues(Bundle bundle, Map<String, String> map) {
        String[] toggles;
        if (Objects.isNull(bundle)) {
            return;
        }
        Dictionary manifestHeaders = bundle.getHeaders();
        if (Objects.isNull(manifestHeaders) || manifestHeaders.isEmpty()) {
            return;
        }
        String headerValue = (String)manifestHeaders.get(manifestHeaderName);
        if (Strings.isInvalidOrBlank((String)headerValue)) {
            return;
        }
        String[] stringArray = toggles = headerValue.split(",");
        int n = toggles.length;
        int n2 = 0;
        while (n2 < n) {
            String[] parts;
            String toggle = stringArray[n2];
            if (!Strings.isInvalidOrBlank((String)toggle) && (parts = toggle.split(";")).length == 2) {
                map.put(parts[0], parts[1]);
            }
            ++n2;
        }
    }

    private static Optional<ToggleAccessor> invokeToggleAccessorFactoryMethod(Class<?> toggleAccessorFactoryClass) {
        try {
            return Optional.ofNullable((ToggleAccessor)toggleAccessorFactoryClass.getMethod(dataBaseToggleAccessorFactoryMethod, new Class[0]).invoke(toggleAccessorFactoryClass, new Object[0]));
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    private static Optional<Class<?>> loadClass(Bundle bundle, String className) {
        try {
            return Optional.ofNullable(((BundleWiring)bundle.adapt(BundleWiring.class)).getClassLoader().loadClass(className));
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    private static Optional<Class<?>> loadToggleAccessorFactoryClass(Bundle bundle) {
        if (Objects.isNull(bundle)) {
            return Optional.empty();
        }
        String implementationClass = implementationClasses.get(bundle.getSymbolicName());
        if (Objects.isNull(implementationClass)) {
            return Optional.empty();
        }
        Optional<Class<?>> toggleAccessorFactoryClassOptional = TogglesFactory.loadClass(bundle, implementationClass);
        return toggleAccessorFactoryClassOptional;
    }

    private static String stringConverter(String value) {
        return value;
    }

    private TogglesFactory() {
    }

    private static enum Location {
        CLIENT,
        SERVER,
        UNKNOWN;

    }

    @FunctionalInterface
    private static interface ToggleFactory<T> {
        public Toggle<T> create(String var1, Function<String, T> var2);
    }

    public static enum ToggleSource {
        BUNDLE_MANIFEST((arg_0, arg_1) -> manifestUnloadedConfigurationToggleFactory.apply(arg_0, arg_1)),
        DATA_BASE((arg_0, arg_1) -> dataBaseToggleFactory.apply(arg_0, arg_1));

        private final ToggleFactory<?> toggleFactory;

        private <T> ToggleSource(ToggleFactory<T> toggleFactory) {
            this.toggleFactory = toggleFactory;
        }

        public <T> Toggle<T> create(String name, Function<String, T> converter) {
            Toggle<?> toggle = this.toggleFactory.create(name, converter);
            return toggle;
        }
    }
}

