/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.keymap;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.vrapper.keymap.KeyBinding;
import net.sourceforge.vrapper.keymap.KeyStroke;
import net.sourceforge.vrapper.keymap.State;
import net.sourceforge.vrapper.keymap.Transition;
import net.sourceforge.vrapper.keymap.UnionState;

public class DynamicState<T>
implements State<T> {
    protected Map<KeyStroke, Transition<T>> map;

    public DynamicState(Collection<KeyBinding<T>> bindings) {
        this.map = new HashMap<KeyStroke, Transition<T>>(bindings.size());
        for (KeyBinding<T> binding : bindings) {
            if (this.map.containsKey(binding.getKeyPress())) continue;
            this.map.put(binding.getKeyPress(), binding.getTransition());
        }
    }

    public DynamicState(KeyBinding<T> ... bindings) {
        this(Arrays.asList(bindings));
    }

    @Override
    public Transition<T> press(KeyStroke key) {
        return this.map.get(key);
    }

    @Override
    public State<T> union(State<T> other) {
        return new UnionState<T>(this, other);
    }

    public void addBinding(KeyBinding<T> leafBind) {
        this.map.put(leafBind.getKeyPress(), leafBind.getTransition());
    }
}

