/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.keymap;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.sourceforge.vrapper.keymap.EmptyState;
import net.sourceforge.vrapper.keymap.KeyBinding;
import net.sourceforge.vrapper.keymap.KeyStroke;
import net.sourceforge.vrapper.keymap.State;
import net.sourceforge.vrapper.keymap.StateUtils;
import net.sourceforge.vrapper.keymap.Transition;
import net.sourceforge.vrapper.keymap.UnionState;

public class HashMapState<T>
implements State<T> {
    protected Map<KeyStroke, Transition<T>> map;

    public HashMapState(Collection<KeyBinding<T>> bindings) {
        this.map = new HashMap<KeyStroke, Transition<T>>(bindings.size());
        for (KeyBinding<T> binding : bindings) {
            if (this.map.containsKey(binding.getKeyPress())) continue;
            this.map.put(binding.getKeyPress(), binding.getTransition());
        }
    }

    protected HashMapState() {
        this.map = new HashMap<KeyStroke, Transition<T>>();
    }

    private HashMapState(Map<KeyStroke, Transition<T>> map) {
        this.map = map;
    }

    @Override
    public Transition<T> press(KeyStroke key) {
        return this.map.get(key);
    }

    public Collection<KeyStroke> supportedKeys() {
        return this.map.keySet();
    }

    @Override
    public State<T> union(State<T> other) {
        HashMapState<T> result = new HashMapState<T>(new HashMap<KeyStroke, Transition<T>>(this.map));
        if (other instanceof EmptyState) {
            return this;
        }
        if (other instanceof HashMapState) {
            HashMapState otherHMS = (HashMapState)other;
            result.map.putAll(this.map);
            result.map.putAll(otherHMS.map);
            HashSet<KeyStroke> commonKeys = new HashSet<KeyStroke>(this.map.keySet());
            commonKeys.retainAll(otherHMS.map.keySet());
            for (KeyStroke key : commonKeys) {
                result.map.put(key, StateUtils.transitionUnion(this.press(key), other.press(key)));
            }
            return result;
        }
        return new UnionState<T>(this, other);
    }
}

