/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.keymap;

import java.util.HashMap;
import java.util.Iterator;
import net.sourceforge.vrapper.keymap.HashMapState;
import net.sourceforge.vrapper.keymap.KeyStroke;
import net.sourceforge.vrapper.keymap.Remapping;
import net.sourceforge.vrapper.keymap.SimpleTransition;
import net.sourceforge.vrapper.keymap.SpecialKey;
import net.sourceforge.vrapper.keymap.Transition;
import net.sourceforge.vrapper.keymap.vim.ConstructorWrappers;

public class KeyMap {
    public static final HashMap<KeyStroke, KeyStroke> GLOBAL_MAP = new HashMap();
    private KeyMapState root = new KeyMapState();
    private final String mapid;

    static {
        GLOBAL_MAP.put(ConstructorWrappers.ctrlKey('['), ConstructorWrappers.key(SpecialKey.ESC));
        GLOBAL_MAP.put(ConstructorWrappers.ctrlKey('C'), ConstructorWrappers.key(SpecialKey.ESC));
        GLOBAL_MAP.put(ConstructorWrappers.ctrlKey('H'), ConstructorWrappers.key(SpecialKey.BACKSPACE));
        GLOBAL_MAP.put(ConstructorWrappers.ctrlKey('I'), ConstructorWrappers.key(SpecialKey.TAB));
        GLOBAL_MAP.put(ConstructorWrappers.ctrlKey('J'), ConstructorWrappers.key(SpecialKey.RETURN));
        GLOBAL_MAP.put(ConstructorWrappers.ctrlKey('M'), ConstructorWrappers.key(SpecialKey.RETURN));
    }

    public KeyMap(String id) {
        this.mapid = id;
    }

    public void addMapping(Iterable<KeyStroke> strokes, Remapping mapping) {
        this.root.addMapping(strokes.iterator(), mapping);
    }

    public void removeMapping(Iterable<KeyStroke> strokes) {
        this.root.removeMapping(strokes.iterator());
    }

    public void clear() {
        this.root = new KeyMapState();
    }

    public Transition<Remapping> press(KeyStroke key) {
        return this.root.press(key);
    }

    public String getMapId() {
        return this.mapid;
    }

    public String toString() {
        return "KeyMap[" + this.mapid + "]";
    }

    private static class KeyMapState
    extends HashMapState<Remapping> {
        int transitions = 0;

        private KeyMapState() {
        }

        private void addMapping(Iterator<KeyStroke> strokes, Remapping mapping) {
            KeyStroke first = strokes.next();
            Transition trans = (Transition)this.map.get(first);
            if (strokes.hasNext()) {
                if (trans != null) {
                    KeyMapState next = (KeyMapState)trans.getNextState();
                    if (next == null) {
                        next = new KeyMapState();
                        this.map.put(first, new SimpleTransition<Remapping>((Remapping)trans.getValue(), next));
                    }
                    next.addMapping(strokes, mapping);
                } else {
                    KeyMapState next = new KeyMapState();
                    this.map.put(first, new SimpleTransition<Remapping>(next));
                    ++this.transitions;
                    next.addMapping(strokes, mapping);
                }
            } else if (trans != null) {
                this.map.put(first, new SimpleTransition<Remapping>(mapping, trans.getNextState()));
            } else {
                ++this.transitions;
                this.map.put(first, new SimpleTransition<Remapping>(mapping));
            }
        }

        private void removeMapping(Iterator<KeyStroke> strokes) {
            KeyStroke first = strokes.next();
            Transition trans = (Transition)this.map.get(first);
            if (strokes.hasNext()) {
                if (trans != null) {
                    KeyMapState next = (KeyMapState)trans.getNextState();
                    if (next != null) {
                        next.removeMapping(strokes);
                        if (next.transitions == 0) {
                            Remapping value = (Remapping)trans.getValue();
                            if (value != null) {
                                this.map.put(first, new SimpleTransition<Remapping>(value));
                            } else {
                                this.map.remove(first);
                                --this.transitions;
                            }
                        }
                    } else {
                        this.map.remove(first);
                        --this.transitions;
                    }
                }
            } else if (trans != null) {
                if (trans.getNextState() == null) {
                    this.map.remove(first);
                    --this.transitions;
                } else {
                    this.map.put(first, new SimpleTransition(trans.getNextState()));
                }
            }
        }
    }
}

