/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.keymap;

import net.sourceforge.vrapper.keymap.ConvertingState;
import net.sourceforge.vrapper.keymap.KeyStroke;
import net.sourceforge.vrapper.keymap.SimpleTransition;
import net.sourceforge.vrapper.keymap.State;
import net.sourceforge.vrapper.keymap.Transition;
import net.sourceforge.vrapper.keymap.UnionState;
import net.sourceforge.vrapper.utils.Function;

public abstract class SequenceState<T1, T2, T3>
implements State<T1> {
    protected final State<T2> first;
    protected final State<T3> second;

    public SequenceState(State<T2> first, State<T3> second) {
        this.first = first;
        this.second = second;
    }

    protected abstract Function<T1, T3> getConverter(T2 var1);

    protected abstract SequenceState<T1, T2, T3> rewrap(State<T2> var1);

    @Override
    public Transition<T1> press(KeyStroke key) {
        State<T1> nextState;
        Transition<T2> transition = this.first.press(key);
        if (transition == null) {
            return null;
        }
        State<T2> newFirst = transition.getNextState();
        if (newFirst != null) {
            nextState = this.rewrap(newFirst);
        } else {
            T2 wrappedResult = transition.getValue();
            if (wrappedResult == null) {
                return null;
            }
            nextState = new Continuation(wrappedResult);
        }
        return new SimpleTransition(nextState);
    }

    @Override
    public State<T1> union(State<T1> other) {
        return new UnionState<T1>(this, other);
    }

    private class Continuation
    extends ConvertingState<T1, T3> {
        public Continuation(T2 intermediate) {
            super(SequenceState.this.getConverter(intermediate), SequenceState.this.second);
        }
    }
}

