/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.keymap;

import net.sourceforge.vrapper.keymap.EmptyState;
import net.sourceforge.vrapper.keymap.SimpleTransition;
import net.sourceforge.vrapper.keymap.State;
import net.sourceforge.vrapper.keymap.Transition;

public class StateUtils {
    public static <T> T firstNonNull(T a, T b) {
        return a != null ? a : b;
    }

    public static <T> State<T> union(State<T> ... states) {
        State<T> result = EmptyState.getInstance();
        State<T>[] stateArray = states;
        int n = states.length;
        int n2 = 0;
        while (n2 < n) {
            State<T> state = stateArray[n2];
            if (state != null) {
                result = result.union(state);
            }
            ++n2;
        }
        return result;
    }

    public static <T> State<T> unionOrNull(State<T> ... states) {
        State<T> result = StateUtils.union(states);
        if (result instanceof EmptyState) {
            return result;
        }
        return null;
    }

    public static <T> Transition<T> transitionUnion(Transition<T> t1, Transition<T> t2) {
        if (t1 == null || t2 == null) {
            return StateUtils.firstNonNull(t1, t2);
        }
        T value = StateUtils.firstNonNull(t1.getValue(), t2.getValue());
        State<T> t1ns = t1.getNextState();
        State<T> t2ns = t2.getNextState();
        State<T> state = t1ns != null && t2ns != null ? t1.getNextState().union(t2.getNextState()) : StateUtils.firstNonNull(t1.getNextState(), t2.getNextState());
        return new SimpleTransition<T>(value, state);
    }
}

