/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.keymap;

import net.sourceforge.vrapper.keymap.ConvertingTransition;
import net.sourceforge.vrapper.keymap.EmptyState;
import net.sourceforge.vrapper.keymap.KeyStroke;
import net.sourceforge.vrapper.keymap.SimpleTransition;
import net.sourceforge.vrapper.keymap.State;
import net.sourceforge.vrapper.keymap.StateUtils;
import net.sourceforge.vrapper.keymap.Transition;
import net.sourceforge.vrapper.keymap.UnionState;
import net.sourceforge.vrapper.utils.Function;
import net.sourceforge.vrapper.utils.IdentityFunction;

public class WrappingState<T>
implements State<T> {
    private final State<Function<T, T>> functions;
    private final State<T> wrapped;
    private final Function<T, T> currentFunction;

    public WrappingState(State<Function<T, T>> functions, State<T> wrapped) {
        this.functions = functions;
        this.wrapped = wrapped;
        this.currentFunction = IdentityFunction.getInstance();
    }

    public WrappingState(Function<T, T> currentFunction, State<Function<T, T>> transformer, State<T> transformed) {
        this.functions = transformer;
        this.wrapped = transformed;
        this.currentFunction = currentFunction;
    }

    @Override
    public Transition<T> press(KeyStroke key) {
        Transition<Function<T, T>> fnTrans = this.functions.press(key);
        if (fnTrans == null) {
            Transition<T> wrTrans = this.wrapped.press(key);
            if (wrTrans == null) {
                return null;
            }
            return new ConvertingTransition<T, T>(this.currentFunction, wrTrans.getValue(), wrTrans.getNextState());
        }
        Function<T, T> nextFn = fnTrans.getValue();
        State<Function<Object, Object>> nextFnState = fnTrans.getNextState();
        if (nextFnState == null) {
            nextFnState = EmptyState.getInstance();
        }
        WrappingState<T> nextState = new WrappingState<T>(nextFn, nextFnState, this.wrapped);
        return new SimpleTransition<T>(nextState);
    }

    @Override
    public State<T> union(State<T> other) {
        if (other instanceof EmptyState) {
            return this;
        }
        if (other instanceof WrappingState) {
            WrappingState otherWS = (WrappingState)other;
            if (this.functions == otherWS.functions && this.currentFunction == otherWS.currentFunction) {
                return new WrappingState<T>(this.currentFunction, this.functions, StateUtils.union(this.wrapped, otherWS.wrapped));
            }
        }
        return new UnionState<T>(this, other);
    }
}

