/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.keymap.vim;

import net.sourceforge.vrapper.keymap.KeyStroke;
import net.sourceforge.vrapper.keymap.SimpleTransition;
import net.sourceforge.vrapper.keymap.State;
import net.sourceforge.vrapper.keymap.Transition;
import net.sourceforge.vrapper.keymap.WrappingState;
import net.sourceforge.vrapper.utils.Function;
import net.sourceforge.vrapper.vim.commands.Counted;

public class CountingState<T extends Counted<T>>
implements State<Function<T, T>> {
    static CountingState<?> INSTANCE = new CountingState(0);
    private final int count;

    private CountingState(int count) {
        this.count = count;
    }

    @Override
    public Transition<Function<T, T>> press(KeyStroke key) {
        char character = key.getCharacter();
        if (key.withCtrlKey()) {
            return null;
        }
        if (!Character.isDigit(character)) {
            return null;
        }
        int lastDigit = Integer.decode(Character.toString(character));
        if (this.count == 0 && lastDigit == 0) {
            return null;
        }
        final int newCount = 10 * this.count + lastDigit;
        Function applyCount = new Function<T, T>(){

            @Override
            public T call(T arg) {
                return (Counted)arg.withCount(newCount);
            }
        };
        return new SimpleTransition<Function<T, T>>(applyCount, new CountingState<T>(newCount));
    }

    @Override
    public State<Function<T, T>> union(State<Function<T, T>> other) {
        throw new UnsupportedOperationException();
    }

    public static <T extends Counted<T>> State<T> wrap(State<T> inner) {
        return new WrappingState<T>(INSTANCE, inner);
    }
}

