/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.keymap.vim;

import java.util.EnumSet;
import java.util.Set;
import net.sourceforge.vrapper.keymap.KeyStroke;
import net.sourceforge.vrapper.keymap.SpecialKey;

public class PlugKeyStroke
implements KeyStroke {
    private String plugId;

    public PlugKeyStroke(String plugId) {
        this.plugId = plugId;
        if (!plugId.startsWith("(") || !plugId.endsWith(")")) {
            throw new IllegalArgumentException("Plug id must start and end with parentheses, got " + plugId);
        }
    }

    public String getId() {
        return this.plugId;
    }

    @Override
    public char getCharacter() {
        return '\u0000';
    }

    @Override
    public SpecialKey getSpecialKey() {
        return SpecialKey.PLUG;
    }

    @Override
    public boolean isVirtual() {
        return true;
    }

    @Override
    public boolean withShiftKey() {
        return false;
    }

    @Override
    public boolean withAltKey() {
        return false;
    }

    @Override
    public boolean withCtrlKey() {
        return false;
    }

    @Override
    public Set<KeyStroke.Modifier> getModifiers() {
        return EnumSet.noneOf(KeyStroke.Modifier.class);
    }

    public int hashCode() {
        int result = 1;
        result = 68281 * result + (this.plugId == null ? 0 : this.plugId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PlugKeyStroke other = (PlugKeyStroke)obj;
        return !(this.plugId == null ? other.plugId != null : !this.plugId.equals(other.plugId));
    }

    public String toString() {
        return "Plug" + this.plugId;
    }
}

