/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.log;

import net.sourceforge.vrapper.log.Log;

public class SystemStreamsLog
implements Log {
    private boolean debugEnabled = Boolean.parseBoolean(System.getProperty("vrapper.debuglog"));

    public SystemStreamsLog(boolean enableDebug) {
        this.debugEnabled = enableDebug;
    }

    @Override
    public void error(String msg, Throwable exception) {
        System.err.println(msg);
        if (exception != null) {
            exception.printStackTrace();
        }
    }

    @Override
    public void info(String msg) {
        System.out.println(msg);
    }

    @Override
    public void debug(String msg) {
        if (this.debugEnabled) {
            System.out.println(msg);
        }
    }

    @Override
    public void setDebugEnabled(boolean enabled) {
        this.debugEnabled = enabled;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }
}

