/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.platform;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.vrapper.platform.Configuration;
import net.sourceforge.vrapper.vim.DefaultConfigProvider;

public class SimpleConfiguration
implements Configuration {
    private String newLine;
    private final Map<Configuration.Option<?>, Object> vars;
    private final List<DefaultConfigProvider> defaultConfigProviders;

    public SimpleConfiguration(List<DefaultConfigProvider> defaultConfigProviders) {
        this.newLine = NewLine.SYSTEM.nl;
        this.vars = new HashMap();
        this.defaultConfigProviders = defaultConfigProviders;
    }

    @Override
    public <T> T get(Configuration.Option<T> key) {
        if (this.isSet(key)) {
            return (T)this.vars.get(key);
        }
        T value = null;
        Iterator<DefaultConfigProvider> it = this.defaultConfigProviders.iterator();
        while (value == null && it.hasNext()) {
            DefaultConfigProvider provider = it.next();
            value = provider.getDefault(key);
        }
        if (value != null) {
            return value;
        }
        return key.getDefaultValue();
    }

    @Override
    public <T> boolean isSet(Configuration.Option<T> key) {
        return this.vars.containsKey(key);
    }

    @Override
    public <T> void set(Configuration.Option<T> key, T value) {
        if (value == null) {
            throw new NullPointerException("value must not be null");
        }
        this.vars.put(key, value);
    }

    @Override
    public String getNewLine() {
        return this.newLine;
    }

    @Override
    public void setNewLine(String newLine) {
        this.newLine = newLine;
    }

    @Override
    public void setNewLine(NewLine newLine) {
        this.newLine = newLine.nl;
    }

    public static enum NewLine {
        MAC("\r"),
        UNIX("\n"),
        WINDOWS("\r\n"),
        SYSTEM(System.getProperty("line.separator")),
        UNKNOWN("\n");

        public final String nl;

        private NewLine(String nl) {
            this.nl = nl;
        }

        public static NewLine parse(String nl) {
            if (nl.startsWith(NewLine.WINDOWS.nl)) {
                return WINDOWS;
            }
            if (nl.startsWith(NewLine.UNIX.nl)) {
                return UNIX;
            }
            if (nl.startsWith(NewLine.MAC.nl)) {
                return UNIX;
            }
            throw new IllegalArgumentException("string does not begin with a known newline");
        }
    }
}

