/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.utils;

import net.sourceforge.vrapper.platform.Configuration;
import net.sourceforge.vrapper.platform.CursorService;
import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.ContentType;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.SelectionArea;
import net.sourceforge.vrapper.utils.StartEndTextRange;
import net.sourceforge.vrapper.utils.TextRange;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.BlockWiseSelection;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;

public class BlockWiseSelectionArea
extends SelectionArea {
    private final int visualWidth;

    public BlockWiseSelectionArea(EditorAdaptor editorAdaptor, BlockWiseSelection selection) {
        BlockWiseSelection.TextBlock rect = BlockWiseSelection.getTextBlock(selection.getFrom(), selection.getTo(), editorAdaptor.getModelContent(), editorAdaptor.getCursorService());
        this.visualWidth = editorAdaptor.getCursorService().shouldStickToEOL() ? Integer.MAX_VALUE : rect.endVisualOffset - rect.startVisualOffset;
        this.linesSpanned = rect.endLine - rect.startLine + 1;
    }

    @Override
    public TextRange getRegion(EditorAdaptor editorAdaptor, int count) throws CommandExecutionException {
        TextContent modelContent = editorAdaptor.getModelContent();
        Position start = editorAdaptor.getPosition();
        LineInformation firstLine = modelContent.getLineInformationOfOffset(start.getModelOffset());
        int lastLineNo = Math.min(firstLine.getNumber() + this.linesSpanned - 1, modelContent.getNumberOfLines() - 1);
        CursorService cursorService = editorAdaptor.getCursorService();
        int startVOffset = cursorService.getVisualOffset(start);
        while (cursorService.getPositionByVisualOffset(lastLineNo, startVOffset) == null && lastLineNo >= firstLine.getNumber()) {
            --lastLineNo;
        }
        Position end = null;
        if (!this.isUntilEOL()) {
            end = cursorService.getPositionByVisualOffset(lastLineNo, startVOffset + this.visualWidth);
        }
        if (end == null) {
            LineInformation lastLine = modelContent.getLineInformation(lastLineNo);
            end = cursorService.newPositionForModelOffset(lastLine.getEndOffset());
        }
        return new StartEndTextRange(start, end);
    }

    @Override
    public ContentType getContentType(Configuration configuration) {
        return ContentType.TEXT_RECTANGLE;
    }

    public boolean isUntilEOL() {
        return this.visualWidth == Integer.MAX_VALUE;
    }
}

