/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.utils;

import java.math.BigInteger;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NumericStringComparator
implements Comparator<String> {
    private boolean binary = false;
    private boolean octal = false;
    private boolean hex = false;
    private boolean usePattern = false;
    private boolean usePatternR = false;
    private String newLine;
    private String pattern = null;

    public NumericStringComparator(String newLine, boolean binary, boolean octal, boolean hex, String pattern, boolean patternR) throws Exception {
        this.newLine = newLine;
        this.binary = binary;
        this.octal = octal;
        this.hex = hex;
        if (pattern != null) {
            this.pattern = pattern;
            this.usePattern = true;
            this.usePatternR = patternR;
        }
    }

    private double getFirstNumber(String str) {
        try {
            if (this.binary) {
                Pattern number = Pattern.compile(".*?((0|1)+)(.|" + this.newLine + ")*");
                Matcher m = number.matcher(str);
                if (m.matches()) {
                    return Double.parseDouble(m.group(1));
                }
                throw new Exception("No binary string found.");
            }
            if (this.octal) {
                Pattern number = Pattern.compile(".*?(([0-7])+)(.|" + this.newLine + ")*");
                Matcher m = number.matcher(str);
                if (m.matches()) {
                    return Double.parseDouble("0" + m.group(1));
                }
                throw new Exception("No octal string found.");
            }
            if (this.hex) {
                Pattern number = Pattern.compile(".*?(([A-Fa-f0-9])+)(.|" + this.newLine + ")*");
                Matcher m = number.matcher(str);
                if (m.matches()) {
                    return new BigInteger(m.group(1), 16).doubleValue();
                }
                throw new Exception("No hex string found.");
            }
            Pattern number = Pattern.compile(".*?([-]?[0-9]+)(.|" + this.newLine + ")*");
            Matcher m = number.matcher(str);
            if (m.matches()) {
                return Double.parseDouble(m.group(1));
            }
            throw new Exception("No numeric string found.");
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    @Override
    public int compare(String str1, String str2) {
        double dub2;
        double dub1;
        if (this.usePattern) {
            str1 = str1.substring(this.usePatternR ? str1.indexOf(this.pattern) : str1.indexOf(this.pattern) + this.pattern.length());
            str2 = str2.substring(this.usePatternR ? str2.indexOf(this.pattern) : str2.indexOf(this.pattern) + this.pattern.length());
        }
        if ((dub1 = this.getFirstNumber(str1)) > (dub2 = this.getFirstNumber(str2))) {
            return 1;
        }
        if (dub1 < dub2) {
            return -1;
        }
        return 0;
    }
}

