/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.utils;

import net.sourceforge.vrapper.utils.Reversible;
import net.sourceforge.vrapper.utils.SearchOffset;

public class Search
implements Reversible<Search> {
    private final String keyword;
    private final boolean backward;
    private final boolean caseSensitive;
    private final boolean regexSearch;
    private final boolean searchInSelection;
    private final SearchOffset afterSearch;

    public Search(String keyword, boolean backward, boolean caseSensitive) {
        this(keyword, backward, caseSensitive, SearchOffset.NONE, false);
    }

    public Search(String keyword, boolean backward, boolean caseSensitive, SearchOffset afterSearch, boolean useRegExp) {
        this(keyword, backward, caseSensitive, afterSearch, useRegExp, false);
    }

    public Search(String keyword, boolean backward, boolean caseSensitive, SearchOffset afterSearch, boolean useRegExp, boolean searchInSelection) {
        this.keyword = keyword;
        this.backward = backward;
        this.caseSensitive = caseSensitive;
        this.afterSearch = afterSearch;
        this.regexSearch = useRegExp;
        this.searchInSelection = searchInSelection;
    }

    @Override
    public Search reverse() {
        return new Search(this.keyword, !this.backward, this.caseSensitive, this.afterSearch, this.regexSearch, this.searchInSelection);
    }

    public String getKeyword() {
        return this.keyword;
    }

    @Override
    public boolean isBackward() {
        return this.backward;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isRegExSearch() {
        return this.regexSearch;
    }

    public boolean isSelectionSearch() {
        return this.searchInSelection;
    }

    public SearchOffset getSearchOffset() {
        return this.afterSearch;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.backward ? 1231 : 1237);
        result = 31 * result + (this.caseSensitive ? 1231 : 1237);
        result = 31 * result + (this.keyword == null ? 0 : this.keyword.hashCode());
        result = 31 * result + (this.regexSearch ? 1231 : 1237);
        result = 31 * result + (this.searchInSelection ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Search other = (Search)obj;
        if (this.backward != other.backward) {
            return false;
        }
        return this.equalsIgnoreDirection(other);
    }

    public boolean equalsIgnoreDirection(Search other) {
        if (other == null) {
            return false;
        }
        if (this.caseSensitive != other.caseSensitive) {
            return false;
        }
        if (this.keyword == null ? other.keyword != null : !this.keyword.equals(other.keyword)) {
            return false;
        }
        if (this.regexSearch != other.regexSearch) {
            return false;
        }
        return this.searchInSelection == other.searchInSelection;
    }
}

