/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.utils;

import net.sourceforge.vrapper.utils.BlockWiseSelectionArea;
import net.sourceforge.vrapper.utils.LineWiseSelectionArea;
import net.sourceforge.vrapper.utils.SimpleSelectionArea;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.BlockWiseSelection;
import net.sourceforge.vrapper.vim.commands.LineWiseSelection;
import net.sourceforge.vrapper.vim.commands.Selection;
import net.sourceforge.vrapper.vim.commands.SimpleSelection;
import net.sourceforge.vrapper.vim.commands.TextObject;

public abstract class SelectionArea
implements TextObject {
    protected int linesSpanned;

    public static SelectionArea getInstance(EditorAdaptor editorAdaptor, Selection selection) {
        if (selection instanceof LineWiseSelection) {
            return new LineWiseSelectionArea(editorAdaptor, (LineWiseSelection)selection);
        }
        if (selection instanceof BlockWiseSelection) {
            return new BlockWiseSelectionArea(editorAdaptor, (BlockWiseSelection)selection);
        }
        return new SimpleSelectionArea(editorAdaptor, (SimpleSelection)selection);
    }

    public int getLinesSpanned() {
        return this.linesSpanned;
    }

    @Override
    public int getCount() {
        return 1;
    }

    @Override
    public TextObject withCount(int count) {
        return this;
    }
}

