/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.utils;

import net.sourceforge.vrapper.platform.Configuration;
import net.sourceforge.vrapper.platform.CursorService;
import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.ContentType;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.utils.LineRange;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.StartEndTextRange;
import net.sourceforge.vrapper.utils.TextRange;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.LineWiseSelection;
import net.sourceforge.vrapper.vim.commands.Selection;
import net.sourceforge.vrapper.vim.commands.TextObject;

public class SimpleLineRange
implements LineRange {
    protected int startLine;
    protected int endLine;
    protected int modelLength;
    private Position from;
    private Position to;

    public static SimpleLineRange entireFile(EditorAdaptor editorAdaptor) {
        SimpleLineRange result = new SimpleLineRange();
        TextContent mc = editorAdaptor.getModelContent();
        CursorService cs = editorAdaptor.getCursorService();
        result.startLine = 0;
        result.endLine = mc.getNumberOfLines() - 1;
        result.modelLength = mc.getTextLength();
        LineInformation lastLine = mc.getLineInformationOfOffset(mc.getTextLength());
        if (lastLine.getLength() == 0 && result.endLine > 0) {
            --result.endLine;
        }
        result.from = cs.newPositionForModelOffset(0);
        result.to = cs.shiftPositionForModelOffset(mc.getTextLength(), -1, false);
        return result;
    }

    public static SimpleLineRange singleLine(EditorAdaptor editorAdaptor, Position position) {
        int modelOffset = position.getModelOffset();
        TextContent mc = editorAdaptor.getModelContent();
        SimpleLineRange result = SimpleLineRange.singleLineInModel(editorAdaptor, mc.getLineInformationOfOffset(modelOffset).getNumber());
        result.from = result.to = position;
        return result;
    }

    public static SimpleLineRange singleLineInModel(EditorAdaptor editorAdaptor, LineInformation modelLine) {
        SimpleLineRange result = new SimpleLineRange();
        result.startLine = result.endLine = modelLine.getNumber();
        CursorService cs = editorAdaptor.getCursorService();
        Position nextLineStart = cs.shiftPositionForModelOffset(modelLine.getEndOffset(), 1, false);
        result.modelLength = nextLineStart.getModelOffset() - modelLine.getBeginOffset();
        result.from = result.to = cs.newPositionForModelOffset(modelLine.getBeginOffset());
        return result;
    }

    public static SimpleLineRange singleLineInModel(EditorAdaptor editorAdaptor, int modelLine) {
        TextContent mc = editorAdaptor.getModelContent();
        LineInformation lineInfo = mc.getLineInformation(modelLine);
        return SimpleLineRange.singleLineInModel(editorAdaptor, lineInfo);
    }

    public static SimpleLineRange betweenPositions(EditorAdaptor editorAdaptor, Position from, Position to) {
        LineInformation endLine;
        LineInformation startLine;
        SimpleLineRange result = new SimpleLineRange();
        TextContent mc = editorAdaptor.getModelContent();
        if (to.compareTo(from) < 0) {
            startLine = mc.getLineInformationOfOffset(to.getModelOffset());
            endLine = mc.getLineInformationOfOffset(from.getModelOffset());
        } else {
            startLine = mc.getLineInformationOfOffset(from.getModelOffset());
            endLine = mc.getLineInformationOfOffset(to.getModelOffset());
        }
        result.startLine = startLine.getNumber();
        result.endLine = endLine.getNumber();
        result.modelLength = StartEndTextRange.lines(editorAdaptor, from, to).getModelLength();
        result.from = from;
        result.to = to;
        return result;
    }

    public static SimpleLineRange fromSelection(EditorAdaptor editorAdaptor, Selection selection) {
        LineInformation endLine;
        LineInformation startLine;
        SimpleLineRange result = new SimpleLineRange();
        TextContent mc = editorAdaptor.getModelContent();
        Position from = selection.getFrom();
        Position to = selection.getTo();
        if (selection.isReversed()) {
            startLine = mc.getLineInformationOfOffset(to.getModelOffset());
            endLine = mc.getLineInformationOfOffset(from.getModelOffset());
        } else {
            startLine = mc.getLineInformationOfOffset(from.getModelOffset());
            endLine = mc.getLineInformationOfOffset(to.getModelOffset());
        }
        result.startLine = startLine.getNumber();
        result.endLine = endLine.getNumber();
        result.modelLength = selection instanceof LineWiseSelection ? selection.getModelLength() : StartEndTextRange.lines(editorAdaptor, from, to).getModelLength();
        result.from = from;
        result.to = to;
        return result;
    }

    public static SimpleLineRange fromTextRange(EditorAdaptor editorAdaptor, TextRange textRange) {
        Position start = textRange.getLeftBound();
        Position end = textRange.getRightBound();
        int endOffset = end.getModelOffset();
        TextContent mc = editorAdaptor.getModelContent();
        LineInformation lastLine = mc.getLineInformationOfOffset(endOffset);
        CursorService cs = editorAdaptor.getCursorService();
        if (endOffset == lastLine.getBeginOffset()) {
            end = cs.shiftPositionForModelOffset(endOffset, -1, false);
        }
        return SimpleLineRange.betweenPositions(editorAdaptor, start, end);
    }

    protected SimpleLineRange() {
    }

    @Override
    public int getStartLine() {
        return this.startLine;
    }

    @Override
    public int getEndLine() {
        return this.endLine;
    }

    @Override
    public int getModelLength() {
        return this.modelLength;
    }

    @Override
    public TextRange getRegion(EditorAdaptor editorAdaptor, int count) throws CommandExecutionException {
        LineInformation startInfo = editorAdaptor.getModelContent().getLineInformation(this.startLine);
        int startOffset = startInfo.getBeginOffset();
        Position start = editorAdaptor.getCursorService().newPositionForModelOffset(startOffset);
        return StartEndTextRange.exclusive(start, start.addModelOffset(this.modelLength));
    }

    @Override
    public ContentType getContentType(Configuration configuration) {
        return ContentType.LINES;
    }

    @Override
    public TextObject withCount(int count) {
        return this;
    }

    @Override
    public int getCount() {
        return 0;
    }

    @Override
    public Position getFrom() {
        return this.from;
    }

    @Override
    public Position getTo() {
        return this.to;
    }
}

