/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.utils;

import net.sourceforge.vrapper.platform.Configuration;
import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.ContentType;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.SelectionArea;
import net.sourceforge.vrapper.utils.StartEndTextRange;
import net.sourceforge.vrapper.utils.TextRange;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.SimpleSelection;

public class SimpleSelectionArea
extends SelectionArea {
    private int trailingCharacters;

    public SimpleSelectionArea(EditorAdaptor editorAdaptor, SimpleSelection selection) {
        TextContent modelContent = editorAdaptor.getModelContent();
        LineInformation startLine = modelContent.getLineInformationOfOffset(selection.getLeftBound().getModelOffset());
        LineInformation endLine = modelContent.getLineInformationOfOffset(selection.getRightBound().getModelOffset());
        this.linesSpanned = endLine.getNumber() - startLine.getNumber() + 1;
        this.trailingCharacters = this.linesSpanned == 1 ? selection.getModelLength() : selection.getRightBound().getModelOffset() - endLine.getBeginOffset();
    }

    @Override
    public TextRange getRegion(EditorAdaptor editorAdaptor, int count) {
        Position end;
        TextContent modelContent = editorAdaptor.getModelContent();
        Position start = editorAdaptor.getPosition();
        if (this.linesSpanned == 1) {
            end = start.addModelOffset(this.trailingCharacters);
        } else {
            LineInformation firstLine = modelContent.getLineInformationOfOffset(start.getModelOffset());
            LineInformation lastLine = modelContent.getLineInformation(firstLine.getNumber() + this.linesSpanned - 1);
            end = editorAdaptor.getCursorService().newPositionForModelOffset(lastLine.getBeginOffset()).addModelOffset(this.trailingCharacters);
        }
        return new StartEndTextRange(start, end);
    }

    @Override
    public ContentType getContentType(Configuration configuration) {
        return ContentType.TEXT;
    }
}

