/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim;

import java.util.Deque;
import java.util.LinkedList;
import java.util.Queue;
import net.sourceforge.vrapper.keymap.KeyStroke;
import net.sourceforge.vrapper.platform.ViewportService;
import net.sourceforge.vrapper.vim.DefaultEditorAdaptor;
import net.sourceforge.vrapper.vim.RemappedKeyStroke;

public class MacroPlayer {
    private final String macroName;
    private final Queue<KeyStroke> playlist;
    private final DefaultEditorAdaptor editorAdaptor;

    MacroPlayer(DefaultEditorAdaptor editorAdaptor, String macroName) {
        this.macroName = macroName;
        this.editorAdaptor = editorAdaptor;
        this.playlist = new LinkedList<KeyStroke>();
    }

    public String getMacroName() {
        return this.macroName;
    }

    public void add(KeyStroke stroke) {
        this.playlist.add(new RemappedKeyStroke(stroke, true));
    }

    public void add(Iterable<KeyStroke> macro) {
        for (KeyStroke stroke : macro) {
            this.playlist.add(new RemappedKeyStroke(stroke, true));
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void play(Deque<String> macroStack) {
        ViewportService view = this.editorAdaptor.getViewportService();
        macroStack.push(this.macroName);
        String historyLock = "macroplayback " + macroStack;
        try {
            block6: {
                block5: {
                    view.setRepaint(false);
                    view.lockRepaint(this);
                    this.editorAdaptor.getHistory().beginCompoundChange();
                    this.editorAdaptor.getHistory().lock(historyLock);
                    if (!true) break block5;
                    if (this.editorAdaptor.abortRecursion) return;
                    if (this.playlist.isEmpty()) break block6;
                }
                do {
                    this.editorAdaptor.handleKeyOffRecord(this.playlist.poll());
                    if (this.editorAdaptor.abortRecursion) return;
                } while (!this.playlist.isEmpty());
            }
            return;
        }
        finally {
            this.editorAdaptor.getHistory().unlock(historyLock);
            this.editorAdaptor.getHistory().endCompoundChange();
            view.unlockRepaint(this);
            view.setRepaint(true);
            macroStack.pop();
        }
    }

    public String toString() {
        return "MacroPlayer(" + this.macroName + ")";
    }
}

