/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.vrapper.keymap.KeyStroke;
import net.sourceforge.vrapper.keymap.vim.ConstructorWrappers;
import net.sourceforge.vrapper.platform.UserInterfaceService;
import net.sourceforge.vrapper.utils.ContentType;
import net.sourceforge.vrapper.vim.register.RegisterManager;
import net.sourceforge.vrapper.vim.register.StringRegisterContent;

public class MacroRecorder {
    private boolean recording;
    private final RegisterManager registerManager;
    private final UserInterfaceService uiService;
    private String macroName;
    private List<KeyStroke> strokes;

    MacroRecorder(RegisterManager registerManager, UserInterfaceService uiService) {
        this.registerManager = registerManager;
        this.uiService = uiService;
    }

    public void startRecording(String macroName) {
        if (macroName == null) {
            throw new NullPointerException("macro name must not be null");
        }
        if (this.recording) {
            throw new IllegalStateException("already recording");
        }
        this.recording = true;
        this.macroName = macroName;
        this.strokes = new ArrayList<KeyStroke>();
        this.uiService.setRecording(true, macroName);
    }

    public void stopRecording() {
        if (!this.recording) {
            throw new IllegalStateException("not recording");
        }
        this.recording = false;
        this.strokes.remove(this.strokes.size() - 1);
        String seq = ConstructorWrappers.keyStrokesToString(this.strokes);
        StringRegisterContent content = new StringRegisterContent(ContentType.KEY_SEQUENCE, seq);
        this.registerManager.getRegister(this.macroName).setContent(content, false);
        this.strokes = null;
        this.macroName = null;
        this.uiService.setRecording(false, this.macroName);
    }

    void handleKey(KeyStroke stroke) {
        if (this.recording) {
            this.strokes.add(stroke);
        }
    }

    public boolean isRecording() {
        return this.recording;
    }
}

