/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.sourceforge.vrapper.platform.Configuration;
import net.sourceforge.vrapper.platform.GlobalConfiguration;
import net.sourceforge.vrapper.platform.SimpleConfiguration;
import net.sourceforge.vrapper.vim.ConfigurationListener;
import net.sourceforge.vrapper.vim.DefaultConfigProvider;

public class SimpleGlobalConfiguration
extends SimpleConfiguration
implements GlobalConfiguration {
    protected List<ConfigurationListener> listeners = new CopyOnWriteArrayList<ConfigurationListener>();

    public SimpleGlobalConfiguration(List<DefaultConfigProvider> defaultConfigProviders) {
        super(defaultConfigProviders);
    }

    @Override
    public <T> void set(Configuration.Option<T> key, T value) {
        T oldValue = super.get(key);
        super.set(key, value);
        for (ConfigurationListener listener : this.listeners) {
            listener.optionChanged(key, oldValue, value);
        }
    }

    @Override
    public void addListener(ConfigurationListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ConfigurationListener listener) {
        this.listeners.remove(listener);
    }
}

