/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.sourceforge.vrapper.platform.Configuration;
import net.sourceforge.vrapper.platform.SimpleConfiguration;
import net.sourceforge.vrapper.vim.ConfigurationListener;
import net.sourceforge.vrapper.vim.DefaultConfigProvider;
import net.sourceforge.vrapper.vim.LocalConfiguration;

public class SimpleLocalConfiguration
extends SimpleConfiguration
implements LocalConfiguration {
    protected Configuration sharedConfiguration;
    protected List<ConfigurationListener> listeners = new CopyOnWriteArrayList<ConfigurationListener>();
    private boolean listenersEnabled;

    public SimpleLocalConfiguration(List<DefaultConfigProvider> defaultConfigProviders, Configuration sharedConfiguration) {
        super(SimpleLocalConfiguration.hookSharedConfigurationProviders(defaultConfigProviders, sharedConfiguration));
        this.sharedConfiguration = sharedConfiguration;
        this.setNewLine(sharedConfiguration.getNewLine());
    }

    protected static final List<DefaultConfigProvider> hookSharedConfigurationProviders(List<DefaultConfigProvider> providers, Configuration sharedConfiguration) {
        ArrayList<DefaultConfigProvider> list = new ArrayList<DefaultConfigProvider>(providers);
        list.add(0, new SharedConfigurationValueProvider(sharedConfiguration));
        list.add(new SharedConfigurationDefaultProvider(sharedConfiguration));
        return list;
    }

    @Override
    public <T> void set(Configuration.Option<T> key, T value) {
        T oldValue = this.sharedConfiguration.get(key);
        if (!key.getScope().equals((Object)Configuration.OptionScope.LOCAL)) {
            this.sharedConfiguration.set(key, value);
        }
        if (this.isSet(key) || key.getScope().equals((Object)Configuration.OptionScope.LOCAL)) {
            oldValue = this.get(key);
            super.set(key, value);
        }
        if (this.listenersEnabled) {
            for (ConfigurationListener listener : this.listeners) {
                listener.optionChanged(key, oldValue, value);
            }
        }
    }

    @Override
    public <T> void setLocal(Configuration.Option<T> key, T value) {
        if (key.getScope() == Configuration.OptionScope.GLOBAL) {
            this.set(key, value);
        } else {
            T oldValue = this.get(key);
            if (key.getScope().equals((Object)Configuration.OptionScope.DEFAULT) && oldValue == null) {
                oldValue = this.sharedConfiguration.get(key);
            }
            super.set(key, value);
            if (this.listenersEnabled) {
                for (ConfigurationListener listener : this.listeners) {
                    listener.optionChanged(key, oldValue, value);
                }
            }
        }
    }

    @Override
    public void setListenersEnabled(boolean enabled) {
        this.listenersEnabled = enabled;
    }

    @Override
    public void addListener(ConfigurationListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ConfigurationListener listener) {
        this.listeners.remove(listener);
    }

    static class SharedConfigurationDefaultProvider
    implements DefaultConfigProvider {
        private Configuration sharedConfiguration;

        public SharedConfigurationDefaultProvider(Configuration sharedConfiguration) {
            this.sharedConfiguration = sharedConfiguration;
        }

        @Override
        public <T> T getDefault(Configuration.Option<T> option) {
            return this.sharedConfiguration.get(option);
        }
    }

    static class SharedConfigurationValueProvider
    implements DefaultConfigProvider {
        private Configuration sharedConfiguration;

        public SharedConfigurationValueProvider(Configuration sharedConfiguration) {
            this.sharedConfiguration = sharedConfiguration;
        }

        @Override
        public <T> T getDefault(Configuration.Option<T> option) {
            if (this.sharedConfiguration.isSet(option)) {
                return this.sharedConfiguration.get(option);
            }
            return null;
        }
    }
}

