/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.vrapper.vim.DefaultEditorAdaptor;
import net.sourceforge.vrapper.vim.VrapperEventListener;
import net.sourceforge.vrapper.vim.modes.EditorMode;

public class VrapperEventListeners {
    protected List<VrapperEventListener> listeners;
    private DefaultEditorAdaptor editorAdaptor;

    public VrapperEventListeners(DefaultEditorAdaptor editorAdaptor) {
        this.editorAdaptor = editorAdaptor;
        this.listeners = new ArrayList<VrapperEventListener>();
    }

    public void addEventListener(VrapperEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeEventListener(VrapperEventListener listener) {
        this.listeners.remove(listener);
    }

    public void fireCommandAboutToExecute() {
        EditorMode currentMode = this.editorAdaptor.currentMode;
        for (VrapperEventListener listener : this.listeners) {
            listener.commandAboutToExecute(currentMode);
        }
    }

    public void fireCommandExecuted() {
        EditorMode currentMode = this.editorAdaptor.currentMode;
        for (VrapperEventListener listener : this.listeners) {
            listener.commandExecuted(currentMode);
        }
    }

    public void fireStateReset(boolean recognized) {
        EditorMode currentMode = this.editorAdaptor.currentMode;
        for (VrapperEventListener listener : this.listeners) {
            listener.stateReset(currentMode, recognized);
        }
    }

    public void fireModeAboutToSwitch(EditorMode newMode) {
        EditorMode currentMode = this.editorAdaptor.currentMode;
        for (VrapperEventListener listener : this.listeners) {
            listener.modeAboutToSwitch(currentMode, newMode);
        }
    }

    public void fireModeSwitched(EditorMode oldMode) {
        EditorMode currentMode = this.editorAdaptor.currentMode;
        for (VrapperEventListener listener : this.listeners) {
            listener.modeSwitched(oldMode, currentMode);
        }
    }

    public void fireVrapperToggled(boolean enabled) {
        for (VrapperEventListener listener : this.listeners) {
            listener.vrapperToggled(enabled);
        }
    }
}

