/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.keymap.KeyStroke;
import net.sourceforge.vrapper.keymap.vim.ConstructorWrappers;
import net.sourceforge.vrapper.platform.CursorService;
import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.platform.ViewportService;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.utils.LineRange;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.SimpleLineRange;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.RemappedKeyStroke;
import net.sourceforge.vrapper.vim.commands.AbstractLinewiseOperation;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.TextOperation;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;
import net.sourceforge.vrapper.vim.modes.ModeSwitchHint;

public class AnonymousMacroOperation
extends AbstractLinewiseOperation {
    private String macro;

    public AnonymousMacroOperation(String macro) {
        this.macro = macro;
    }

    @Override
    public TextOperation repetition() {
        return null;
    }

    @Override
    public LineRange getDefaultRange(EditorAdaptor editorAdaptor, int count, Position currentPos) throws CommandExecutionException {
        return SimpleLineRange.singleLine(editorAdaptor, currentPos);
    }

    @Override
    public void execute(EditorAdaptor editorAdaptor, LineRange lineRange) throws CommandExecutionException {
        CursorService cursor = editorAdaptor.getCursorService();
        TextContent model = editorAdaptor.getModelContent();
        Iterable<KeyStroke> parsed = ConstructorWrappers.parseKeyStrokes(this.macro);
        boolean resetPos = true;
        if (lineRange.getStartLine() == lineRange.getEndLine()) {
            cursor.setPosition(lineRange.getFrom(), StickyColumnPolicy.NEVER);
            resetPos = false;
        }
        ViewportService view = editorAdaptor.getViewportService();
        try {
            view.setRepaint(false);
            view.lockRepaint(this);
            editorAdaptor.getHistory().beginCompoundChange();
            editorAdaptor.getHistory().lock("normal-command");
            int i = lineRange.getStartLine();
            while (i <= lineRange.getEndLine()) {
                if (resetPos) {
                    LineInformation lineInfo = model.getLineInformation(i);
                    Position lineStart = cursor.newPositionForModelOffset(lineInfo.getBeginOffset());
                    editorAdaptor.setPosition(lineStart, StickyColumnPolicy.NEVER);
                }
                for (KeyStroke key : parsed) {
                    editorAdaptor.handleKeyOffRecord(new RemappedKeyStroke(key, true));
                }
                if (!"normal mode".equals(editorAdaptor.getCurrentModeName())) {
                    editorAdaptor.changeModeSafely("normal mode", new ModeSwitchHint[0]);
                }
                ++i;
            }
        }
        finally {
            editorAdaptor.getHistory().unlock("normal-command");
            editorAdaptor.getHistory().endCompoundChange();
            view.unlockRepaint(this);
            view.setRepaint(true);
        }
    }
}

