/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.platform.UserInterfaceService;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.AbstractCommand;
import net.sourceforge.vrapper.vim.commands.Command;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;

public class AsciiCommand
extends AbstractCommand {
    private UserInterfaceService userInterfaceService;
    public static AsciiCommand INSTANCE = new AsciiCommand();
    private static final char CTRL_AT = '\u0000';
    private static final char CTRL_A = '\u0001';
    private static final char CTRL_B = '\u0002';
    private static final char CTRL_C = '\u0003';
    private static final char CTRL_D = '\u0004';
    private static final char CTRL_E = '\u0005';
    private static final char CTRL_F = '\u0006';
    private static final char CTRL_G = '\u0007';
    private static final char CTRL_H = '\b';
    private static final char CTRL_I = '\t';
    private static final char CTRL_J = '\n';
    private static final char CTRL_K = '\u000b';
    private static final char CTRL_L = '\f';
    private static final char CTRL_M = '\r';
    private static final char CTRL_N = '\u000e';
    private static final char CTRL_O = '\u000f';
    private static final char CTRL_P = '\u0010';
    private static final char CTRL_Q = '\u0011';
    private static final char CTRL_R = '\u0012';
    private static final char CTRL_S = '\u0013';
    private static final char CTRL_T = '\u0014';
    private static final char CTRL_U = '\u0015';
    private static final char CTRL_V = '\u0016';
    private static final char CTRL_W = '\u0017';
    private static final char CTRL_X = '\u0018';
    private static final char CTRL_Y = '\u0019';
    private static final char CTRL_Z = '\u001a';
    private static final char CTRL_BSL = '\u001c';
    private static final char CTRL_RSB = '\u001d';
    private static final char CTRL_HAT = '\u001e';
    private static final char CTRL__ = '\u001f';

    @Override
    public void execute(EditorAdaptor editorAdaptor) throws CommandExecutionException {
        this.userInterfaceService = editorAdaptor.getUserInterfaceService();
        int offset = editorAdaptor.getCursorService().getPosition().getModelOffset();
        if (editorAdaptor.getModelContent().getTextLength() == 0) {
            this.userInterfaceService.setInfoMessage("NUL");
            return;
        }
        if (editorAdaptor.getModelContent().getTextLength() <= offset) {
            this.userInterfaceService.setInfoMessage("NUL");
            return;
        }
        String asciiStr = editorAdaptor.getModelContent().getText(offset, 1);
        int ascii = 0;
        if (asciiStr.length() == 1) {
            ascii = asciiStr.charAt(0);
        }
        switch (ascii) {
            case 0: {
                asciiStr = "^@";
                break;
            }
            case 1: {
                asciiStr = "^A";
                break;
            }
            case 2: {
                asciiStr = "^B";
                break;
            }
            case 3: {
                asciiStr = "^C";
                break;
            }
            case 4: {
                asciiStr = "^D";
                break;
            }
            case 5: {
                asciiStr = "^E";
                break;
            }
            case 6: {
                asciiStr = "^F";
                break;
            }
            case 7: {
                asciiStr = "^G";
                break;
            }
            case 8: {
                asciiStr = "^H";
                break;
            }
            case 9: {
                asciiStr = "^I";
                break;
            }
            case 10: {
                asciiStr = "^J";
                break;
            }
            case 11: {
                asciiStr = "^K";
                break;
            }
            case 12: {
                asciiStr = "^L";
                break;
            }
            case 13: {
                asciiStr = "^M";
                break;
            }
            case 14: {
                asciiStr = "^N";
                break;
            }
            case 15: {
                asciiStr = "^O";
                break;
            }
            case 16: {
                asciiStr = "^P";
                break;
            }
            case 17: {
                asciiStr = "^Q";
                break;
            }
            case 18: {
                asciiStr = "^R";
                break;
            }
            case 19: {
                asciiStr = "^S";
                break;
            }
            case 20: {
                asciiStr = "^T";
                break;
            }
            case 21: {
                asciiStr = "^U";
                break;
            }
            case 22: {
                asciiStr = "^V";
                break;
            }
            case 23: {
                asciiStr = "^W";
                break;
            }
            case 24: {
                asciiStr = "^X";
                break;
            }
            case 25: {
                asciiStr = "^Y";
                break;
            }
            case 26: {
                asciiStr = "^Z";
                break;
            }
            case 28: {
                asciiStr = "^\\";
                break;
            }
            case 29: {
                asciiStr = "^]";
                break;
            }
            case 30: {
                asciiStr = "^^";
                break;
            }
            case 31: {
                asciiStr = "^_";
                break;
            }
        }
        this.userInterfaceService.setAsciiValues(asciiStr, ascii, String.format("%02x", ascii), String.format("%03o", ascii));
        this.userInterfaceService.setInfoSet(true);
    }

    @Override
    public Command repetition() {
        return null;
    }

    @Override
    public Command withCount(int count) {
        return null;
    }
}

