/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.commands;

import net.sourceforge.vrapper.platform.CursorService;
import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.StringUtils;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;
import net.sourceforge.vrapper.vim.register.RegisterContent;
import net.sourceforge.vrapper.vim.register.TextBlockRegisterContent;

public abstract class BlockPasteHelper {
    public static void execute(EditorAdaptor editorAdaptor, int count, int startOfs, boolean placeCursorAfter) {
        RegisterContent registerContent = editorAdaptor.getRegisterManager().getActiveRegister().getContent();
        Position pos = editorAdaptor.getPosition();
        try {
            editorAdaptor.getHistory().beginCompoundChange();
            int newCursorOfs = BlockPasteHelper.execute(editorAdaptor, count, startOfs, placeCursorAfter, registerContent, pos);
            Position destination = editorAdaptor.getCursorService().newPositionForModelOffset(newCursorOfs);
            editorAdaptor.setPosition(destination, StickyColumnPolicy.ON_CHANGE);
        }
        finally {
            editorAdaptor.getHistory().endCompoundChange();
        }
    }

    public static int execute(EditorAdaptor editorAdaptor, int count, int startOfs, boolean placeCursorAfter, RegisterContent registerContent, Position pos) {
        CursorService cursorService = editorAdaptor.getCursorService();
        TextContent content = editorAdaptor.getModelContent();
        LineInformation line = content.getLineInformationOfOffset(pos.getModelOffset());
        int startLine = line.getNumber();
        TextBlockRegisterContent rect = (TextBlockRegisterContent)registerContent;
        int newCursorOfs = cursorService.shiftPositionForModelOffset(pos.getModelOffset(), startOfs, false).getModelOffset();
        int vWidth = rect.getVisualWidth();
        int i = 0;
        while (i < rect.getNumLines()) {
            if (startLine + i >= content.getNumberOfLines() - 1) {
                content.replace(content.getTextLength(), 0, editorAdaptor.getConfiguration().getNewLine());
            }
            LineInformation pasteLine = content.getLineInformation(startLine + i);
            int vOffset = cursorService.getVisualOffset(pos);
            int c = 0;
            while (c < count) {
                Position pastePos = cursorService.getPositionByVisualOffset(startLine + i, vOffset);
                if (pastePos == null) {
                    pastePos = cursorService.newPositionForModelOffset(pasteLine.getEndOffset());
                    int lineEndVOfs = cursorService.getVisualOffset(pastePos);
                    int padding = cursorService.visualWidthToChars(vOffset - lineEndVOfs);
                    content.replace(pasteLine.getEndOffset(), 0, StringUtils.multiply(" ", padding));
                    pastePos = pastePos.addModelOffset(padding);
                }
                pasteLine = content.getLineInformation(startLine + i);
                if (startOfs > 0 && pasteLine.getEndOffset() == pastePos.getModelOffset()) {
                    content.replace(pasteLine.getEndOffset(), 0, " ");
                }
                String blockLine = rect.getLine(i);
                content.replace(pastePos.addModelOffset(startOfs).getModelOffset(), 0, blockLine);
                pastePos = pastePos.addModelOffset(blockLine.length());
                if (pastePos.getModelOffset() + startOfs < pasteLine.getEndOffset() + blockLine.length() || c != count - 1) {
                    int vEndOfs = cursorService.getVisualOffset(pastePos);
                    int padding = cursorService.visualWidthToChars(vOffset + vWidth - vEndOfs) + 1;
                    content.replace(pastePos.addModelOffset(startOfs).getModelOffset(), 0, StringUtils.multiply(" ", padding));
                    pastePos = pastePos.addModelOffset(padding);
                }
                vOffset = cursorService.getVisualOffset(pastePos);
                if (placeCursorAfter) {
                    newCursorOfs = pastePos.getModelOffset() + startOfs;
                }
                ++c;
            }
            ++i;
        }
        return newCursorOfs;
    }
}

